/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.spark.source.reader.batch;

import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SupportCoordinate;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.translation.spark.source.partition.batch.BatchPartition;
import org.apache.seatunnel.translation.spark.utils.TypeConverterUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.v2.reader.DataSourceReader;
import org.apache.spark.sql.sources.v2.reader.InputPartition;
import org.apache.spark.sql.types.StructType;

public class BatchSourceReader
implements DataSourceReader {
    protected final SeaTunnelSource<SeaTunnelRow, ?, ?> source;
    protected final Integer parallelism;

    public BatchSourceReader(SeaTunnelSource<SeaTunnelRow, ?, ?> source, Integer parallelism) {
        this.source = source;
        this.parallelism = parallelism;
    }

    public StructType readSchema() {
        return (StructType)TypeConverterUtils.convert((SeaTunnelDataType)this.source.getProducedType());
    }

    public List<InputPartition<InternalRow>> planInputPartitions() {
        ArrayList<InputPartition<InternalRow>> virtualPartitions;
        if (this.source instanceof SupportCoordinate) {
            virtualPartitions = new ArrayList<InputPartition<InternalRow>>(1);
            virtualPartitions.add(new BatchPartition(this.source, this.parallelism, 0));
        } else {
            virtualPartitions = new ArrayList(this.parallelism);
            for (int subtaskId = 0; subtaskId < this.parallelism; ++subtaskId) {
                virtualPartitions.add(new BatchPartition(this.source, this.parallelism, subtaskId));
            }
        }
        return virtualPartitions;
    }
}

