/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.spark.source.reader.micro;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SupportCoordinate;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.utils.SerializationUtils;
import org.apache.seatunnel.translation.spark.source.partition.micro.MicroBatchPartition;
import org.apache.seatunnel.translation.spark.source.state.MicroBatchState;
import org.apache.seatunnel.translation.spark.utils.TypeConverterUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.v2.reader.InputPartition;
import org.apache.spark.sql.sources.v2.reader.streaming.MicroBatchReader;
import org.apache.spark.sql.sources.v2.reader.streaming.Offset;
import org.apache.spark.sql.types.StructType;

public class MicroBatchSourceReader
implements MicroBatchReader {
    protected final SeaTunnelSource<SeaTunnelRow, ?, ?> source;
    protected final Integer parallelism;
    protected final Integer checkpointInterval;
    protected final String checkpointPath;
    protected final String hdfsRoot;
    protected final String hdfsUser;
    protected Integer checkpointId;
    protected MicroBatchState startOffset;
    protected MicroBatchState endOffset;

    public MicroBatchSourceReader(SeaTunnelSource<SeaTunnelRow, ?, ?> source, Integer parallelism, Integer checkpointId, Integer checkpointInterval, String checkpointPath, String hdfsRoot, String hdfsUser) {
        this.source = source;
        this.parallelism = parallelism;
        this.checkpointId = checkpointId;
        this.checkpointInterval = checkpointInterval;
        this.checkpointPath = checkpointPath;
        this.hdfsRoot = hdfsRoot;
        this.hdfsUser = hdfsUser;
    }

    public void setOffsetRange(Optional<Offset> start, Optional<Offset> end) {
        this.startOffset = (MicroBatchState)start.orElse(new MicroBatchState(this.checkpointId));
        this.checkpointId = this.startOffset.getCheckpointId();
        this.endOffset = (MicroBatchState)end.orElse(new MicroBatchState(this.startOffset.getCheckpointId() + 1));
    }

    public Offset getStartOffset() {
        return this.startOffset;
    }

    public Offset getEndOffset() {
        return this.endOffset;
    }

    public Offset deserializeOffset(String microBatchState) {
        return (Offset)SerializationUtils.stringToObject((String)microBatchState);
    }

    public void commit(Offset end) {
    }

    public void stop() {
    }

    public StructType readSchema() {
        return (StructType)TypeConverterUtils.convert((SeaTunnelDataType)this.source.getProducedType());
    }

    public List<InputPartition<InternalRow>> planInputPartitions() {
        ArrayList<InputPartition<InternalRow>> virtualPartitions;
        if (this.source instanceof SupportCoordinate) {
            virtualPartitions = new ArrayList<InputPartition<InternalRow>>(1);
            virtualPartitions.add(new MicroBatchPartition(this.source, this.parallelism, 0, this.checkpointId, this.checkpointInterval, this.checkpointPath, this.hdfsRoot, this.hdfsUser));
        } else {
            virtualPartitions = new ArrayList(this.parallelism);
            for (int subtaskId = 0; subtaskId < this.parallelism; ++subtaskId) {
                virtualPartitions.add(new MicroBatchPartition(this.source, this.parallelism, subtaskId, this.checkpointId, this.checkpointInterval, this.checkpointPath, this.hdfsRoot, this.hdfsUser));
            }
        }
        Integer n = this.checkpointId;
        Integer n2 = this.checkpointId = Integer.valueOf(this.checkpointId + 1);
        return virtualPartitions;
    }
}

