/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.utils;

import com.uber.h3core.H3Core;
import com.uber.h3core.exceptions.H3Exception;
import com.uber.h3core.util.LatLng;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.sedona.common.utils.GeomUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class H3Utils {
    public static H3Core h3;
    public static Map<Integer, Double> cellSizeMap;

    public static LatLng coordindateToLatLng(Coordinate coordinate) {
        return new LatLng(coordinate.getY(), coordinate.getX());
    }

    public static Coordinate cellToCoordinate(long cell) {
        LatLng latLng = h3.cellToLatLng(cell);
        return new Coordinate(latLng.lng, latLng.lat);
    }

    public static long coordinateToCell(Coordinate coordinate, int level) {
        return h3.latLngToCell(coordinate.getY(), coordinate.getX(), level);
    }

    public static List<Long> polygonToCells(Polygon polygon, int level, boolean fullCover) {
        try {
            List shell = Arrays.stream(polygon.getExteriorRing().getCoordinates()).map(H3Utils::coordindateToLatLng).collect(Collectors.toList());
            ArrayList holes = new ArrayList();
            for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                holes.add(Arrays.stream(polygon.getInteriorRingN(i).getCoordinates()).map(H3Utils::coordindateToLatLng).collect(Collectors.toList()));
            }
            List internalCells = h3.polygonToCells(shell, holes.isEmpty() ? null : holes, level);
            if (internalCells.isEmpty()) {
                internalCells.add(H3Utils.coordinateToCell(polygon.getCentroid().getCoordinate(), level));
            }
            if (fullCover) {
                HashSet<Long> cells = new HashSet<Long>();
                internalCells.forEach(cell -> cells.addAll(h3.gridDisk(cell.longValue(), 1)));
                cells.addAll(H3Utils.lineStringToCells((LineString)polygon.getExteriorRing(), level, true));
                for (int it = 0; it < polygon.getNumInteriorRing(); ++it) {
                    LinearRing hole = polygon.getInteriorRingN(it);
                    cells.addAll(H3Utils.lineStringToCells((LineString)hole, level, true));
                }
                return new ArrayList<Long>(cells);
            }
            return internalCells;
        }
        catch (H3Exception e) {
            throw new H3UtilException(String.format("fail to cover the polygon %s with error %s", GeomUtils.getWKT((Geometry)polygon), e.getMessage()), e);
        }
    }

    public static double latLngDistance(double lat1, double lat2, double lon1, double lon2) {
        int R = 6371;
        double latDistance = Math.toRadians(lat2 - lat1);
        double lonDistance = Math.toRadians(lon2 - lon1);
        double a = Math.sin(latDistance / 2.0) * Math.sin(latDistance / 2.0) + Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) * Math.sin(lonDistance / 2.0) * Math.sin(lonDistance / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return 6371.0 * c;
    }

    public static List<Long> approxPathCells(Coordinate sc, Coordinate ec, int level, boolean safe) {
        double approxDistance = H3Utils.latLngDistance(sc.y, ec.y, sc.x, ec.x);
        int itCellNum = Math.max((int)(approxDistance / cellSizeMap.get(level) * 3.0), 1);
        double xUnit = (ec.getX() - sc.getX()) / (double)itCellNum;
        double yUnit = (ec.getY() - sc.getY()) / (double)itCellNum;
        LinkedHashSet<Long> cells = new LinkedHashSet<Long>();
        for (int it = 0; it <= itCellNum; ++it) {
            cells.add(H3Utils.coordinateToCell(new Coordinate(sc.getX() + xUnit * (double)it, sc.getY() + yUnit * (double)it), level));
        }
        ArrayList approxCells = new ArrayList(cells);
        cells.clear();
        cells.add((Long)approxCells.get(0));
        HashSet closetNeighbors = new HashSet(h3.gridDisk(((Long)approxCells.get(0)).longValue(), 1));
        ArrayList<Long> candidates = new ArrayList<Long>();
        int it = 1;
        while (it < approxCells.size()) {
            long curCell = (Long)approxCells.get(it);
            if (closetNeighbors.contains(curCell)) {
                candidates.add(curCell);
                ++it;
                continue;
            }
            long pickedCandidate = 0L;
            for (Long candidate : candidates) {
                List candidateNeighbors = h3.gridDisk(candidate.longValue(), 1);
                if (!candidateNeighbors.contains(curCell)) continue;
                pickedCandidate = candidate;
                if (it + 1 >= approxCells.size() || !candidateNeighbors.contains(approxCells.get(it + 1))) continue;
                break;
            }
            if (pickedCandidate != 0L) {
                cells.add(pickedCandidate);
                candidates.clear();
                closetNeighbors = new HashSet(h3.gridDisk(pickedCandidate, 1));
                continue;
            }
            if (!safe) {
                cells.add((Long)candidates.get(0));
                cells.add(curCell);
                closetNeighbors = new HashSet(h3.gridDisk(curCell, 1));
                candidates.clear();
                ++it;
                continue;
            }
            throw new H3UtilException(String.format("fail to approximate path between cell %d to %d, generated gap cell %d", H3Utils.coordinateToCell(sc, level), H3Utils.coordinateToCell(ec, level), curCell));
        }
        if (!candidates.isEmpty()) {
            cells.add((Long)candidates.get(0));
        }
        return new ArrayList<Long>(cells);
    }

    public static List<Long> lineStringToCells(LineString line, int level, boolean fullCover) {
        try {
            Coordinate[] coordinates = line.getCoordinates();
            LinkedHashSet<Long> cells = new LinkedHashSet<Long>();
            for (int pairE = 1; pairE < coordinates.length; ++pairE) {
                Coordinate cs = coordinates[pairE - 1];
                Coordinate ce = coordinates[pairE];
                long cellS = H3Utils.coordinateToCell(cs, level);
                long cellE = H3Utils.coordinateToCell(ce, level);
                try {
                    List<Long> pathCells;
                    try {
                        pathCells = h3.gridPathCells(cellS, cellE);
                    }
                    catch (H3Exception e) {
                        pathCells = H3Utils.approxPathCells(cs, ce, level, true);
                    }
                    if (pathCells.size() <= 2 || !fullCover) {
                        cells.addAll(pathCells);
                        continue;
                    }
                    HashSet prevNeighbors = new HashSet(h3.gridDisk(pathCells.get(0).longValue(), 1));
                    for (int it = 1; it < pathCells.size(); ++it) {
                        HashSet neighbors = new HashSet(h3.gridDisk(pathCells.get(it).longValue(), 1));
                        prevNeighbors.retainAll(neighbors);
                        cells.addAll(prevNeighbors);
                        prevNeighbors = neighbors;
                    }
                    continue;
                }
                catch (H3UtilException e) {
                    if (fullCover) {
                        cells.addAll(H3Utils.polygonToCells((Polygon)new GeometryFactory().createLineString(new Coordinate[]{cs, ce}).getEnvelope(), level, true));
                        continue;
                    }
                    throw e;
                }
            }
            return new ArrayList<Long>(cells);
        }
        catch (Exception e) {
            throw new H3UtilException(String.format("fail to cover the line %s with error %s", GeomUtils.getWKT((Geometry)line), e.getMessage()), e);
        }
    }

    static {
        try {
            h3 = H3Core.newInstance();
        }
        catch (IOException e) {
            throw new H3UtilException(e);
        }
        cellSizeMap = new HashMap<Integer, Double>();
        cellSizeMap.put(0, 1257.1651279870703);
        cellSizeMap.put(1, 415.1068893923832);
        cellSizeMap.put(2, 147.84174424387626);
        cellSizeMap.put(3, 54.530253595150185);
        cellSizeMap.put(4, 20.426305676421265);
        cellSizeMap.put(5, 7.693156379723934);
        cellSizeMap.put(6, 2.9039922554770365);
        cellSizeMap.put(7, 1.097050477001042);
        cellSizeMap.put(8, 0.4145696618254594);
        cellSizeMap.put(9, 0.15668127143434735);
        cellSizeMap.put(10, 0.059218394287200805);
        cellSizeMap.put(11, 0.022382219491694798);
        cellSizeMap.put(12, 0.008459648046313144);
        cellSizeMap.put(13, 0.0031974550140400557);
        cellSizeMap.put(14, 0.0012085926447938334);
        cellSizeMap.put(15, 4.567448929842399E-4);
    }

    public static class H3UtilException
    extends RuntimeException {
        public H3UtilException(Throwable cause) {
            super(cause);
        }

        public H3UtilException(String message) {
            super(message);
        }

        public H3UtilException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

