/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.formatMapper.shapefileParser;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.sedona.core.formatMapper.shapefileParser.boundary.BoundBox;
import org.apache.sedona.core.formatMapper.shapefileParser.boundary.BoundaryInputFormat;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.TypeUnknownException;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.PrimitiveShape;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.ShapeInputFormat;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.ShapeKey;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.VoidFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.Tuple2;

@Deprecated
public class ShapefileRDD
implements Serializable {
    public static GeometryFactory geometryFactory = new GeometryFactory();
    private static final Function<Tuple2<ShapeKey, PrimitiveShape>, Geometry> PrimitiveToShape = new Function<Tuple2<ShapeKey, PrimitiveShape>, Geometry>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Geometry call(Tuple2<ShapeKey, PrimitiveShape> primitiveTuple) {
            Geometry shape = null;
            try {
                shape = primitiveTuple._2().getShape(geometryFactory);
                return shape;
            }
            catch (TypeUnknownException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                return shape;
            }
        }
    };
    private final VoidFunction<Geometry> PrintShape = new VoidFunction<Geometry>(){

        public void call(Geometry shape) throws Exception {
            System.out.println(shape.toText());
        }
    };
    private JavaRDD<Geometry> shapeRDD = null;
    private BoundBox boundBox = new BoundBox();

    public ShapefileRDD(JavaSparkContext sparkContext, String filePath) {
        JavaPairRDD shapePrimitiveRdd = sparkContext.newAPIHadoopFile(filePath, ShapeInputFormat.class, ShapeKey.class, PrimitiveShape.class, sparkContext.hadoopConfiguration());
        this.shapeRDD = shapePrimitiveRdd.map(PrimitiveToShape);
    }

    public JavaRDD<Geometry> getShapeRDD() {
        return this.shapeRDD;
    }

    public JavaRDD<Point> getPointRDD() {
        return this.shapeRDD.flatMap((FlatMapFunction)new FlatMapFunction<Geometry, Point>(){

            public Iterator<Point> call(Geometry spatialObject) throws Exception {
                ArrayList<Point> result = new ArrayList<Point>();
                if (spatialObject instanceof MultiPoint) {
                    MultiPoint multiObjects = (MultiPoint)spatialObject;
                    for (int i = 0; i < multiObjects.getNumGeometries(); ++i) {
                        Point oneObject = (Point)multiObjects.getGeometryN(i);
                        oneObject.setUserData(multiObjects.getUserData());
                        result.add(oneObject);
                    }
                } else if (spatialObject instanceof Point) {
                    result.add((Point)spatialObject);
                } else {
                    throw new Exception("[ShapefileRDD][getPointRDD] the object type is not Point or MultiPoint type. It is " + spatialObject.getGeometryType());
                }
                return result.iterator();
            }
        });
    }

    public JavaRDD<Polygon> getPolygonRDD() {
        return this.shapeRDD.flatMap((FlatMapFunction)new FlatMapFunction<Geometry, Polygon>(){

            public Iterator<Polygon> call(Geometry spatialObject) throws Exception {
                ArrayList<Polygon> result = new ArrayList<Polygon>();
                if (spatialObject instanceof MultiPolygon) {
                    MultiPolygon multiObjects = (MultiPolygon)spatialObject;
                    for (int i = 0; i < multiObjects.getNumGeometries(); ++i) {
                        Polygon oneObject = (Polygon)multiObjects.getGeometryN(i);
                        oneObject.setUserData(multiObjects.getUserData());
                        result.add(oneObject);
                    }
                } else if (spatialObject instanceof Polygon) {
                    result.add((Polygon)spatialObject);
                } else {
                    throw new Exception("[ShapefileRDD][getPolygonRDD] the object type is not Polygon or MultiPolygon type. It is " + spatialObject.getGeometryType());
                }
                return result.iterator();
            }
        });
    }

    public JavaRDD<LineString> getLineStringRDD() {
        return this.shapeRDD.flatMap((FlatMapFunction)new FlatMapFunction<Geometry, LineString>(){

            public Iterator<LineString> call(Geometry spatialObject) throws Exception {
                ArrayList<LineString> result = new ArrayList<LineString>();
                if (spatialObject instanceof MultiLineString) {
                    MultiLineString multiObjects = (MultiLineString)spatialObject;
                    for (int i = 0; i < multiObjects.getNumGeometries(); ++i) {
                        LineString oneObject = (LineString)multiObjects.getGeometryN(i);
                        oneObject.setUserData(multiObjects.getUserData());
                        result.add(oneObject);
                    }
                } else if (spatialObject instanceof LineString) {
                    result.add((LineString)spatialObject);
                } else {
                    throw new Exception("[ShapefileRDD][getLineStringRDD] the object type is not LineString or MultiLineString type. It is " + spatialObject.getGeometryType());
                }
                return result.iterator();
            }
        });
    }

    public long count() {
        return this.shapeRDD.count();
    }

    public BoundBox getBoundBox(JavaSparkContext sc, String inputPath) {
        JavaPairRDD bounds = sc.newAPIHadoopFile(inputPath, BoundaryInputFormat.class, Long.class, BoundBox.class, sc.hadoopConfiguration());
        if ((bounds = bounds.reduceByKey((Function2)new Function2<BoundBox, BoundBox, BoundBox>(){

            public BoundBox call(BoundBox box1, BoundBox box2) throws Exception {
                return BoundBox.mergeBoundBox(box1, box2);
            }
        })).count() > 0L) {
            return new BoundBox((BoundBox)((Tuple2)bounds.collect().get(0))._2());
        }
        return null;
    }
}

