/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.monitoring;

import java.io.Serializable;
import org.apache.spark.Success$;
import org.apache.spark.TaskEndReason;
import org.apache.spark.scheduler.AccumulableInfo;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import scala.Console$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.math.Ordering$Long$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0$mcJ$sp;

@ScalaSignature(bytes="\u0006\u0001a3A\u0001C\u0005\u0001)!)Q\u0004\u0001C\u0001=!9\u0011\u0005\u0001b\u0001\n\u0013\u0011\u0003BB\u001a\u0001A\u0003%1\u0005C\u00045\u0001\t\u0007I\u0011B\u001b\t\r\u0019\u0003\u0001\u0015!\u00037\u0011\u00159\u0005\u0001\"\u0011I\u0011\u0015\t\u0006\u0001\"\u0011S\u0005!a\u0015n\u001d;f]\u0016\u0014(B\u0001\u0006\f\u0003)iwN\\5u_JLgn\u001a\u0006\u0003\u00195\tAaY8sK*\u0011abD\u0001\u0007g\u0016$wN\\1\u000b\u0005A\t\u0012AB1qC\u000eDWMC\u0001\u0013\u0003\ry'oZ\u0002\u0001'\t\u0001Q\u0003\u0005\u0002\u001775\tqC\u0003\u0002\u00193\u0005I1o\u00195fIVdWM\u001d\u0006\u00035=\tQa\u001d9be.L!\u0001H\f\u0003\u001bM\u0003\u0018M]6MSN$XM\\3s\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002!\u00015\t\u0011\"\u0001\u0007d_VtG/\u001a:OC6,7/F\u0001$!\r!\u0013fK\u0007\u0002K)\u0011aeJ\u0001\u000bG>dG.Z2uS>t'\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005)*#aA*fcB\u0011A&M\u0007\u0002[)\u0011afL\u0001\u0005Y\u0006twMC\u00011\u0003\u0011Q\u0017M^1\n\u0005Ij#AB*ue&tw-A\u0007d_VtG/\u001a:OC6,7\u000fI\u0001\fi\u0006\u001c8n\u00119v)&lW-F\u00017!\u00119$\bP\"\u000e\u0003aR!!O\u0013\u0002\u000f5,H/\u00192mK&\u00111\b\u000f\u0002\u0004\u001b\u0006\u0004\b\u0003B\u001f?\u0001\u0002k\u0011aJ\u0005\u0003\u007f\u001d\u0012a\u0001V;qY\u0016\u0014\u0004C\u0001\u0017B\u0013\t\u0011UFA\u0004J]R,w-\u001a:\u0011\u0005u\"\u0015BA#(\u0005\u0011auN\\4\u0002\u0019Q\f7o[\"qkRKW.\u001a\u0011\u0002\u0013=tG+Y:l\u000b:$GCA%M!\ti$*\u0003\u0002LO\t!QK\\5u\u0011\u0015ie\u00011\u0001O\u0003\u001d!\u0018m]6F]\u0012\u0004\"AF(\n\u0005A;\"\u0001F*qCJ\\G*[:uK:,'\u000fV1tW\u0016sG-\u0001\tp]N#\u0018mZ3D_6\u0004H.\u001a;fIR\u0011\u0011j\u0015\u0005\u0006)\u001e\u0001\r!V\u0001\u000fgR\fw-Z\"p[BdW\r^3e!\t1b+\u0003\u0002X/\tY2\u000b]1sW2K7\u000f^3oKJ\u001cF/Y4f\u0007>l\u0007\u000f\\3uK\u0012\u0004")
public class Listener
extends SparkListener {
    private final Seq<String> counterNames = new $colon$colon<Nothing$>((Nothing$)((Object)"buildCount"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"streamCount"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"candidateCount"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"resultCount"), Nil$.MODULE$))));
    private final Map<Tuple2<Integer, Integer>, Object> taskCpuTime = (Map)Map$.MODULE$.apply(Nil$.MODULE$);

    private Seq<String> counterNames() {
        return this.counterNames;
    }

    private Map<Tuple2<Integer, Integer>, Object> taskCpuTime() {
        return this.taskCpuTime;
    }

    public void onTaskEnd(SparkListenerTaskEnd taskEnd) {
        block0: {
            TaskEndReason taskEndReason = taskEnd.reason();
            Success$ success$ = Success$.MODULE$;
            if (taskEndReason != null ? !taskEndReason.equals(success$) : success$ != null) break block0;
            long cpuTime = taskEnd.taskMetrics().executorCpuTime();
            int partitionId = Integer.parseInt(new StringOps(Predef$.MODULE$.augmentString(taskEnd.taskInfo().id())).split('.')[0]);
            this.taskCpuTime().update(new Tuple2<Integer, Integer>(Predef$.MODULE$.int2Integer(taskEnd.stageId()), Predef$.MODULE$.int2Integer(partitionId)), BoxesRunTime.boxToLong(cpuTime));
        }
    }

    public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
        block0: {
            HashMap accumulables = stageCompleted.stageInfo().accumulables();
            if (!Listener.getCounterOption$1("buildCount", accumulables).isDefined()) break block0;
            int stageId = stageCompleted.stageInfo().stageId();
            scala.collection.immutable.Map buildCounts = (scala.collection.immutable.Map)Listener.getCounter$1("buildCount", accumulables);
            scala.collection.immutable.Map streamCounts = (scala.collection.immutable.Map)Listener.getCounter$1("streamCount", accumulables);
            scala.collection.immutable.Map candidateCounts = (scala.collection.immutable.Map)Listener.getCounter$1("candidateCount", accumulables);
            scala.collection.immutable.Map resultCounts = (scala.collection.immutable.Map)Listener.getCounter$1("resultCount", accumulables);
            List stats = (List)((TraversableOnce)buildCounts.map((Function1<Tuple2, Tuple6> & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                int partitionId = tuple2._1$mcI$sp();
                long buildCount = tuple2._2$mcJ$sp();
                long streamCount = BoxesRunTime.unboxToLong(streamCounts.getOrElse(BoxesRunTime.boxToInteger(partitionId), (JFunction0$mcJ$sp & scala.Serializable)() -> -1L));
                long candidateCount = BoxesRunTime.unboxToLong(candidateCounts.getOrElse(BoxesRunTime.boxToInteger(partitionId), (JFunction0$mcJ$sp & scala.Serializable)() -> -1L));
                long resultCount = BoxesRunTime.unboxToLong(resultCounts.getOrElse(BoxesRunTime.boxToInteger(partitionId), (JFunction0$mcJ$sp & scala.Serializable)() -> -1L));
                long cpuTime = BoxesRunTime.unboxToLong(this.taskCpuTime().getOrElse(new Tuple2<Integer, Integer>(Predef$.MODULE$.int2Integer(stageId), Predef$.MODULE$.int2Integer(partitionId)), (JFunction0$mcJ$sp & scala.Serializable)() -> -1L));
                Tuple6<Integer, Long, Long, Long, Long, Long> tuple6 = new Tuple6<Integer, Long, Long, Long, Long, Long>(BoxesRunTime.boxToInteger(partitionId), BoxesRunTime.boxToLong(buildCount), BoxesRunTime.boxToLong(streamCount), BoxesRunTime.boxToLong(candidateCount), BoxesRunTime.boxToLong(resultCount), BoxesRunTime.boxToLong(cpuTime));
                return tuple6;
            }, Iterable$.MODULE$.canBuildFrom())).toList().sortBy((Function1<Tuple6, Object> & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToLong(Listener.$anonfun$onStageCompleted$7(x0$2)), (Ordering)Ordering$Long$.MODULE$);
            Console$.MODULE$.out().println("Spatial join is complete. Execution statistics:");
            Console$.MODULE$.out().println("Partition\t CPU Time (s)\tBuild ##\tStream ##\tCandidates ##\tResults ##");
            stats.foreach((Function1<Tuple6, Object> & Serializable & scala.Serializable)x0$3 -> {
                Listener.$anonfun$onStageCompleted$8(x0$3);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$onStageCompleted$1(String name$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        AccumulableInfo v = (AccumulableInfo)tuple2._2();
        Option option = v.name();
        Some<String> some = new Some<String>(new StringBuilder(19).append("sedona.spatialjoin.").append(name$1).toString());
        boolean bl = !(option != null ? !option.equals(some) : some != null);
        return bl;
    }

    private static final Option getCounterOption$1(String name, HashMap accumulables$1) {
        return accumulables$1.find((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean(Listener.$anonfun$onStageCompleted$1(name, x0$1)));
    }

    private static final Object getCounter$1(String name, HashMap accumulables$1) {
        return ((AccumulableInfo)((Tuple2)Listener.getCounterOption$1(name, accumulables$1).get())._2()).value().get();
    }

    public static final /* synthetic */ long $anonfun$onStageCompleted$7(Tuple6 x0$2) {
        long cpuTime;
        Tuple6 tuple6 = x0$2;
        if (tuple6 == null) {
            throw new MatchError(tuple6);
        }
        long l = cpuTime = BoxesRunTime.unboxToLong(tuple6._6());
        return l;
    }

    public static final /* synthetic */ void $anonfun$onStageCompleted$8(Tuple6 x0$3) {
        Tuple6 tuple6 = x0$3;
        if (tuple6 == null) {
            throw new MatchError(tuple6);
        }
        int partitionId = BoxesRunTime.unboxToInt(tuple6._1());
        long buildCount = BoxesRunTime.unboxToLong(tuple6._2());
        long streamCount = BoxesRunTime.unboxToLong(tuple6._3());
        long candidateCount = BoxesRunTime.unboxToLong(tuple6._4());
        long resultCount = BoxesRunTime.unboxToLong(tuple6._5());
        long cpuTime = BoxesRunTime.unboxToLong(tuple6._6());
        int arg$macro$1 = partitionId;
        long arg$macro$2 = cpuTime / 1000L;
        long arg$macro$3 = buildCount;
        long arg$macro$4 = streamCount;
        long arg$macro$5 = candidateCount;
        long arg$macro$6 = resultCount;
        Console$.MODULE$.out().println(new StringBuilder(0).append(new StringOps("% 10d\t% 10d").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(arg$macro$1), BoxesRunTime.boxToLong(arg$macro$2)}))).append(new StringOps("% 10d\t% 10d\t% 10d\t% 10d").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(arg$macro$3), BoxesRunTime.boxToLong(arg$macro$4), BoxesRunTime.boxToLong(arg$macro$5), BoxesRunTime.boxToLong(arg$macro$6)}))).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }
}

