/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialPartitioning;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.sedona.core.enums.GridType;
import org.apache.sedona.core.joinJudgement.DedupParams;
import org.apache.sedona.core.spatialPartitioning.SpatialPartitioner;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import scala.Tuple2;

public class FlatGridPartitioner
extends SpatialPartitioner {
    public FlatGridPartitioner(GridType gridType, List<Envelope> grids) {
        super(gridType, grids);
    }

    public FlatGridPartitioner(List<Envelope> grids) {
        super(null, grids);
    }

    @Override
    public <T extends Geometry> Iterator<Tuple2<Integer, T>> placeObject(T spatialObject) throws Exception {
        Objects.requireNonNull(spatialObject, "spatialObject");
        int overflowContainerID = this.grids.size();
        Envelope envelope = spatialObject.getEnvelopeInternal();
        HashSet<Tuple2<Integer, T>> result = new HashSet<Tuple2<Integer, T>>();
        boolean containFlag = false;
        for (int i = 0; i < this.grids.size(); ++i) {
            Envelope grid = (Envelope)this.grids.get(i);
            if (grid.covers(envelope)) {
                result.add(new Tuple2<Integer, T>(i, spatialObject));
                containFlag = true;
                continue;
            }
            if (!grid.intersects(envelope) && !envelope.covers(grid)) continue;
            result.add(new Tuple2<Integer, T>(i, spatialObject));
        }
        if (!containFlag) {
            result.add(new Tuple2<Integer, T>(overflowContainerID, spatialObject));
        }
        return result.iterator();
    }

    @Override
    @Nullable
    public DedupParams getDedupParams() {
        return null;
    }

    public int numPartitions() {
        return this.grids.size() + 1;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof FlatGridPartitioner)) {
            return false;
        }
        FlatGridPartitioner other = (FlatGridPartitioner)o;
        if (this.gridType == null || other.gridType == null) {
            return other.grids.equals(this.grids);
        }
        return other.gridType.equals(this.gridType) && other.grids.equals(this.grids);
    }
}

