/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialPartitioning;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.sedona.core.enums.GridType;
import org.apache.sedona.core.joinJudgement.DedupParams;
import org.apache.sedona.core.spatialPartitioning.KDBTree;
import org.apache.sedona.core.spatialPartitioning.SpatialPartitioner;
import org.apache.sedona.core.utils.HalfOpenRectangle;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import scala.Tuple2;

public class KDBTreePartitioner
extends SpatialPartitioner {
    private final KDBTree tree;

    public KDBTreePartitioner(KDBTree tree) {
        super(GridType.KDBTREE, KDBTreePartitioner.getLeafZones(tree));
        this.tree = tree;
        this.tree.dropElements();
    }

    private static List<Envelope> getLeafZones(KDBTree tree) {
        final ArrayList<Envelope> leafs = new ArrayList<Envelope>();
        tree.traverse(new KDBTree.Visitor(){

            @Override
            public boolean visit(KDBTree tree) {
                if (tree.isLeaf()) {
                    leafs.add(tree.getExtent());
                }
                return true;
            }
        });
        return leafs;
    }

    public int numPartitions() {
        return this.grids.size();
    }

    @Override
    public <T extends Geometry> Iterator<Tuple2<Integer, T>> placeObject(T spatialObject) throws Exception {
        Objects.requireNonNull(spatialObject, "spatialObject");
        Envelope envelope = spatialObject.getEnvelopeInternal();
        List<KDBTree> matchedPartitions = this.tree.findLeafNodes(envelope);
        Point point = spatialObject instanceof Point ? (Point)spatialObject : null;
        HashSet<Tuple2<Integer, T>> result = new HashSet<Tuple2<Integer, T>>();
        for (KDBTree leaf : matchedPartitions) {
            if (point != null && !new HalfOpenRectangle(leaf.getExtent()).contains(point)) continue;
            result.add(new Tuple2<Integer, T>(leaf.getLeafId(), spatialObject));
        }
        return result.iterator();
    }

    @Override
    @Nullable
    public DedupParams getDedupParams() {
        return new DedupParams(this.grids);
    }
}

