/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.python.wrapper.translation;

import java.nio.ByteBuffer;
import org.apache.sedona.core.geometryObjects.Circle;
import org.apache.sedona.python.wrapper.SerializationException;
import org.apache.sedona.python.wrapper.SerializationException$;
import org.apache.sedona.python.wrapper.translation.CircleSerializer;
import org.apache.sedona.python.wrapper.translation.GeometrySerializer;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKBReader;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a2Q\u0001B\u0003\u0001\u0013EAQa\u0007\u0001\u0005\u0002uAQ\u0001\t\u0001\u0005\u0002\u0005BQ!\u000e\u0001\u0005\u0002Y\u0012\u0001\u0004U=uQ>tw)Z8nKR\u0014\u0018pU3sS\u0006d\u0017N_3s\u0015\t1q!A\u0006ue\u0006t7\u000f\\1uS>t'B\u0001\u0005\n\u0003\u001d9(/\u00199qKJT!AC\u0006\u0002\rALH\u000f[8o\u0015\taQ\"\u0001\u0004tK\u0012|g.\u0019\u0006\u0003\u001d=\ta!\u00199bG\",'\"\u0001\t\u0002\u0007=\u0014xmE\u0002\u0001%a\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007CA\n\u001a\u0013\tQBC\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004=S:LGOP\u0002\u0001)\u0005q\u0002CA\u0010\u0001\u001b\u0005)\u0011!C:fe&\fG.\u001b>f+\u0005\u0011\u0003\u0003B\n$K=J!\u0001\n\u000b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001\u0014.\u001b\u00059#B\u0001\u0015*\u0003\u00119Wm\\7\u000b\u0005)Z\u0013a\u00016ug*\u0011AfD\u0001\rY>\u001c\u0017\r^5p]R,7\r[\u0005\u0003]\u001d\u0012\u0001bR3p[\u0016$(/\u001f\t\u0004'A\u0012\u0014BA\u0019\u0015\u0005\u0015\t%O]1z!\t\u00192'\u0003\u00025)\t!!)\u001f;f\u0003-!Wm]3sS\u0006d\u0017N_3\u0016\u0003]\u0002BaE\u00120K\u0001")
public class PythonGeometrySerializer
implements Serializable {
    public Function1<Geometry, byte[]> serialize() {
        return (Function1<Geometry, byte[]> & java.io.Serializable & Serializable)x0$1 -> {
            byte[] byArray;
            Geometry geometry = x0$1;
            if (geometry instanceof Circle) {
                Circle circle = (Circle)geometry;
                byArray = new CircleSerializer(circle).serialize();
            } else if (geometry != null) {
                Geometry geometry2 = geometry;
                byArray = new GeometrySerializer(geometry2).serialize();
            } else {
                throw new MatchError(geometry);
            }
            return byArray;
        };
    }

    public Function1<byte[], Geometry> deserialize() {
        return (Function1<byte[], Geometry> & java.io.Serializable & Serializable)values -> {
            Geometry geometry;
            WKBReader reader = new WKBReader();
            byte isCircle = BoxesRunTime.unboxToByte(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])values)).head());
            int valuesLength = ((byte[])values).length;
            if (isCircle == 1) {
                Geometry geom = reader.read((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])values)).slice(9, valuesLength));
                double radius = ByteBuffer.wrap((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])values)).slice(1, 9)).getDouble();
                geometry = new Circle(geom, Predef$.MODULE$.double2Double(radius));
            } else if (isCircle == 0) {
                geometry = reader.read((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])values)).slice(1, valuesLength));
            } else {
                throw new SerializationException("Can not deserialize object", SerializationException$.MODULE$.apply$default$2());
            }
            return geometry;
        };
    }
}

