/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.expressions.geohash;

import org.apache.spark.sql.sedona_sql.expressions.geohash.InvalidGeoHashException;
import org.apache.spark.sql.sedona_sql.expressions.geohash.LatLon;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps$;
import scala.math.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1$mcVI$sp;

public final class GeoHashDecoder$ {
    public static GeoHashDecoder$ MODULE$;
    private final Seq<Object> bits;
    private final String base32;
    private final GeometryFactory geometryFactory;

    static {
        new GeoHashDecoder$();
    }

    private Seq<Object> bits() {
        return this.bits;
    }

    private String base32() {
        return this.base32;
    }

    public GeometryFactory geometryFactory() {
        return this.geometryFactory;
    }

    public Geometry decode(String geohash, Option<Object> precision) {
        return this.decodeGeoHashBBox(geohash, precision).getBbox().toPolygon();
    }

    public Option<Object> decode$default$2() {
        return None$.MODULE$;
    }

    private LatLon decodeGeoHashBBox(String geohash, Option<Object> precision) {
        int n;
        LatLon latLon = new LatLon((scala.collection.mutable.Seq)scala.collection.mutable.Seq$.MODULE$.apply(Predef$.MODULE$.wrapDoubleArray(new double[]{-180.0, 180.0})), (scala.collection.mutable.Seq)scala.collection.mutable.Seq$.MODULE$.apply(Predef$.MODULE$.wrapDoubleArray(new double[]{-90.0, 90.0})));
        String geoHashLowered = geohash.toLowerCase();
        int geoHashLength = geohash.length();
        Option<Object> option = precision;
        if (option instanceof Some) {
            Some some = (Some)option;
            int value = BoxesRunTime.unboxToInt(some.value());
            if (value < 0) {
                throw new InvalidGeoHashException("Precision can not be negative");
            }
            n = package$.MODULE$.min(geoHashLength, value);
        } else if (None$.MODULE$.equals(option)) {
            n = geoHashLength;
        } else {
            throw new MatchError(option);
        }
        int targetPrecision = n;
        BooleanRef isEven = BooleanRef.create(true);
        scala.package$.MODULE$.Range().apply(0, targetPrecision).foreach$mVc$sp((JFunction1$mcVI$sp & Serializable)i -> {
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(geoHashLowered), i);
            byte cd = (byte)MODULE$.base32().indexOf(c);
            if (cd == -1) {
                throw new InvalidGeoHashException(new StringBuilder(36).append("Invalid character '").append(c).append("' found at index ").append(i).toString());
            }
            scala.package$.MODULE$.Range().apply(0, 5).foreach$mVc$sp((JFunction1$mcVI$sp & Serializable)j -> {
                int index;
                byte mask = (byte)BoxesRunTime.unboxToInt(MODULE$.bits().apply(j));
                int n = index = (byte)(mask & cd) == 0 ? 1 : 0;
                if (isEven$1.elem) {
                    latLon.lons().update(index, BoxesRunTime.boxToDouble((BoxesRunTime.unboxToDouble(latLon.lons().head()) + BoxesRunTime.unboxToDouble(latLon.lons().apply(true))) / (double)2));
                } else {
                    latLon.lats().update(index, BoxesRunTime.boxToDouble((BoxesRunTime.unboxToDouble(latLon.lats().head()) + BoxesRunTime.unboxToDouble(latLon.lats().apply(true))) / (double)2));
                }
                isEven$1.elem = !isEven$1.elem;
            });
        });
        return latLon;
    }

    private Option<Object> decodeGeoHashBBox$default$2() {
        return None$.MODULE$;
    }

    private GeoHashDecoder$() {
        MODULE$ = this;
        this.bits = (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{16, 8, 4, 2, 1}));
        this.base32 = "0123456789bcdefghjkmnpqrstuvwxyz";
        this.geometryFactory = new GeometryFactory();
    }
}

