/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.expressions.geohash;

import org.apache.spark.sql.sedona_sql.expressions.geohash.PointGeoHashEncoder$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import scala.None$;
import scala.Option;
import scala.Some;

public final class GeometryGeoHashEncoder$ {
    public static GeometryGeoHashEncoder$ MODULE$;
    private final GeometryFactory geometryFactory;

    static {
        new GeometryGeoHashEncoder$();
    }

    private GeometryFactory geometryFactory() {
        return this.geometryFactory;
    }

    public Option<String> calculate(Geometry geom, int precision) {
        Option option;
        Envelope gbox = geom.getEnvelope().getEnvelopeInternal();
        if (gbox.getMinX() < (double)-180 || gbox.getMinY() < (double)-90 || gbox.getMaxX() > (double)180 || gbox.getMaxX() > (double)90) {
            option = None$.MODULE$;
        } else {
            double lon = gbox.getMinX() + (gbox.getMaxX() - gbox.getMinX()) / (double)2;
            double lat = gbox.getMinY() + (gbox.getMaxY() - gbox.getMinY()) / (double)2;
            option = new Some<String>(PointGeoHashEncoder$.MODULE$.calculateGeoHash(this.geometryFactory().createPoint(new Coordinate(lon, lat)), precision));
        }
        return option;
    }

    private GeometryGeoHashEncoder$() {
        MODULE$ = this;
        this.geometryFactory = new GeometryFactory();
    }
}

