/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.apache.sedona.common.utils.GeomUtils;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.execution.datasources.parquet.GeoDataSourceUtils$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetWriteSupport$GeometryColumnBoundingBox$;
import org.apache.spark.sql.execution.datasources.parquet.GeometryFieldMetaData;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.SparkToParquetSchemaConverter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.package$;
import org.apache.spark.sql.sedona_sql.UDT.GeometryUDT$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKBWriter;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rEh\u0001\u0002-Z\u0001!DQA \u0001\u0005\u0002},a!!\u0002\u0001\t\u0005\u001d\u0001bCA\u0016\u0001\u0001\u0007\t\u0019!C\u0005\u0003[A1\"a\u000f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002>!Y\u00111\t\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0018\u0011-\t)\u0005\u0001a\u0001\u0002\u0004%I!a\u0012\t\u0017\u0005M\u0003\u00011AA\u0002\u0013%\u0011Q\u000b\u0005\f\u00033\u0002\u0001\u0019!A!B\u0013\tI\u0005C\u0006\u0002\\\u0001\u0001\r\u00111A\u0005\n\u0005u\u0003bCA7\u0001\u0001\u0007\t\u0019!C\u0005\u0003_B1\"a\u001d\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002`!Y\u0011Q\u000f\u0001A\u0002\u0003\u0007I\u0011BA<\u0011-\ty\b\u0001a\u0001\u0002\u0004%I!!!\t\u0017\u0005\u0015\u0005\u00011A\u0001B\u0003&\u0011\u0011\u0010\u0005\f\u0003\u000f\u0003\u0001\u0019!a\u0001\n\u0013\tI\tC\u0006\u0002(\u0002\u0001\r\u00111A\u0005\n\u0005%\u0006bCAW\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0017C\u0011\"a,\u0001\u0005\u0004%I!!-\t\u0011\u0005m\u0006\u0001)A\u0005\u0003gC\u0011\"!0\u0001\u0005\u0004%I!!-\t\u0011\u0005}\u0006\u0001)A\u0005\u0003gC\u0011\"!1\u0001\u0005\u0004%I!a1\t\u0011\u0005%\b\u0001)A\u0005\u0003\u000bD\u0011\"a;\u0001\u0005\u0004%I!!<\t\u0011\u0005U\b\u0001)A\u0005\u0003_D\u0011\"a>\u0001\u0005\u0004%I!!?\t\u0011\t\r\u0001\u0001)A\u0005\u0003wD\u0011B!\u0002\u0001\u0005\u0004%I!a1\t\u0011\t\u001d\u0001\u0001)A\u0005\u0003\u000bD\u0011B!\u0003\u0001\u0005\u0004%I!!?\t\u0011\t-\u0001\u0001)A\u0005\u0003wD\u0011B!\u0004\u0001\u0005\u0004%IAa\u0004\t\u0011\tU\b\u0001)A\u0005\u0005#A\u0011Ba>\u0001\u0001\u0004%IA!?\t\u0013\r\u0005\u0001\u00011A\u0005\n\r\r\u0001\u0002CB\u0004\u0001\u0001\u0006KAa?\t\u0013\r%\u0001\u00011A\u0005\n\r-\u0001\"CB\u0013\u0001\u0001\u0007I\u0011BB\u0014\u0011!\u0019Y\u0003\u0001Q!\n\r5\u0001\"CB\u0017\u0001\t\u0007I\u0011BB\u0018\u0011!\u0019\u0019\u0004\u0001Q\u0001\n\rE\u0002bBB\u001b\u0001\u0011\u00053q\u0007\u0005\b\u0007K\u0002A\u0011IB4\u0011\u001d\u0019Y\u0007\u0001C!\u0007[Bqaa\u001e\u0001\t\u0003\u001aI\bC\u0004\u0004\u0000\u0001!Ia!!\t\u000f\r-\u0005\u0001\"\u0003\u0004\u000e\"I1q\u0014\u0001\u0012\u0002\u0013%1\u0011\u0015\u0005\b\u0007K\u0003A\u0011BBT\u0011\u001d\u0019\t\f\u0001C\u0001\u0007gCqaa0\u0001\t\u0013\u0019\t\rC\u0004\u0004N\u0002!Iaa4\t\u000f\rm\u0007\u0001\"\u0003\u0004^\"91\u0011\u001d\u0001\u0005\n\r\rxa\u0002B\u00193\"\u0005!1\u0007\u0004\u00071fC\tA!\u000e\t\ryDD\u0011\u0001B\u001f\r\u0019\u0011y\u0004\u000f\u0001\u0003B!1aP\u000fC\u0001\u0005\u0007B\u0011B!\u0013;\u0005\u0004%\tAa\u0013\t\u0011\t\u001d&\b)A\u0005\u0005\u001bB\u0011B!+;\u0005\u0004%\tAa+\t\u0011\t\r'\b)A\u0005\u0005[CqA!$;\t\u0003\u0011)M\u0002\u0004\u0003Pa\u0002!\u0011\u000b\u0005\u000b\u0005'\n%\u00111A\u0005\u0002\tU\u0003B\u0003B/\u0003\n\u0005\r\u0011\"\u0001\u0003`!Q!1M!\u0003\u0002\u0003\u0006KAa\u0016\t\u0015\t\u0015\u0014I!a\u0001\n\u0003\u0011)\u0006\u0003\u0006\u0003h\u0005\u0013\t\u0019!C\u0001\u0005SB!B!\u001cB\u0005\u0003\u0005\u000b\u0015\u0002B,\u0011)\u0011y'\u0011BA\u0002\u0013\u0005!Q\u000b\u0005\u000b\u0005c\n%\u00111A\u0005\u0002\tM\u0004B\u0003B<\u0003\n\u0005\t\u0015)\u0003\u0003X!Q!\u0011P!\u0003\u0002\u0004%\tA!\u0016\t\u0015\tm\u0014I!a\u0001\n\u0003\u0011i\b\u0003\u0006\u0003\u0002\u0006\u0013\t\u0011)Q\u0005\u0005/BaA`!\u0005\u0002\t\r\u0005b\u0002BG\u0003\u0012\u0005!qR\u0004\n\u0005\u0013D\u0014\u0011!E\u0001\u0005\u00174\u0011Ba\u00149\u0003\u0003E\tA!4\t\ry\fF\u0011\u0001Bh\u0011%\u0011\t.UI\u0001\n\u0003\u0011\u0019\u000eC\u0005\u0003jF\u000b\n\u0011\"\u0001\u0003T\"I!1^)\u0012\u0002\u0013\u0005!1\u001b\u0005\n\u0005[\f\u0016\u0013!C\u0001\u0005'DqAa<9\t\u0013\u0011\tP\u0001\fHK>\u0004\u0016M]9vKR<&/\u001b;f'V\u0004\bo\u001c:u\u0015\tQ6,A\u0004qCJ\fX/\u001a;\u000b\u0005qk\u0016a\u00033bi\u0006\u001cx.\u001e:dKNT!AX0\u0002\u0013\u0015DXmY;uS>t'B\u00011b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003E\u000e\fQa\u001d9be.T!\u0001Z3\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0017aA8sO\u000e\u00011c\u0001\u0001jqB\u0019!\u000e\u001d:\u000e\u0003-T!\u0001\\7\u0002\u0007\u0005\u0004\u0018N\u0003\u0002o_\u00061\u0001.\u00193p_BT!AW2\n\u0005E\\'\u0001D,sSR,7+\u001e9q_J$\bCA:w\u001b\u0005!(BA;`\u0003!\u0019\u0017\r^1msN$\u0018BA<u\u0005-Ie\u000e^3s]\u0006d'k\\<\u0011\u0005edX\"\u0001>\u000b\u0005m\f\u0017\u0001C5oi\u0016\u0014h.\u00197\n\u0005uT(a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005\u0005\u0001cAA\u0002\u00015\t\u0011LA\u0006WC2,Xm\u0016:ji\u0016\u0014\bCCA\u0005\u0003\u001f\t\u0019\"a\b\u0002&5\u0011\u00111\u0002\u0006\u0003\u0003\u001b\tQa]2bY\u0006LA!!\u0005\u0002\f\tIa)\u001e8di&|gN\r\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011\u0004;\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0003;\t9B\u0001\nTa\u0016\u001c\u0017.\u00197ju\u0016$w)\u001a;uKJ\u001c\b\u0003BA\u0005\u0003CIA!a\t\u0002\f\t\u0019\u0011J\u001c;\u0011\t\u0005%\u0011qE\u0005\u0005\u0003S\tYA\u0001\u0003V]&$\u0018AB:dQ\u0016l\u0017-\u0006\u0002\u00020A!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u00026}\u000bQ\u0001^=qKNLA!!\u000f\u00024\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u0015M\u001c\u0007.Z7b?\u0012*\u0017\u000f\u0006\u0003\u0002&\u0005}\u0002\"CA!\t\u0005\u0005\t\u0019AA\u0018\u0003\rAH%M\u0001\bg\u000eDW-\\1!\u0003A\u0011xn\u001c;GS\u0016dGm\u0016:ji\u0016\u00148/\u0006\u0002\u0002JA1\u0011\u0011BA&\u0003\u001fJA!!\u0014\u0002\f\t)\u0011I\u001d:bsB\u0019\u0011\u0011\u000b\u0002\u000e\u0003\u0001\tAC]8pi\u001aKW\r\u001c3Xe&$XM]:`I\u0015\fH\u0003BA\u0013\u0003/B\u0011\"!\u0011\b\u0003\u0003\u0005\r!!\u0013\u0002#I|w\u000e\u001e$jK2$wK]5uKJ\u001c\b%\u0001\bsK\u000e|'\u000fZ\"p]N,X.\u001a:\u0016\u0005\u0005}\u0003\u0003BA1\u0003Sj!!a\u0019\u000b\u00071\f)GC\u0002\u0002h=\f!![8\n\t\u0005-\u00141\r\u0002\u000f%\u0016\u001cwN\u001d3D_:\u001cX/\\3s\u0003I\u0011XmY8sI\u000e{gn];nKJ|F%Z9\u0015\t\u0005\u0015\u0012\u0011\u000f\u0005\n\u0003\u0003R\u0011\u0011!a\u0001\u0003?\nqB]3d_J$7i\u001c8tk6,'\u000fI\u0001\u0019oJLG/\u001a'fO\u0006\u001c\u0017\u0010U1scV,GOR8s[\u0006$XCAA=!\u0011\tI!a\u001f\n\t\u0005u\u00141\u0002\u0002\b\u0005>|G.Z1o\u0003q9(/\u001b;f\u0019\u0016<\u0017mY=QCJ\fX/\u001a;G_Jl\u0017\r^0%KF$B!!\n\u0002\u0004\"I\u0011\u0011I\u0007\u0002\u0002\u0003\u0007\u0011\u0011P\u0001\u001aoJLG/\u001a'fO\u0006\u001c\u0017\u0010U1scV,GOR8s[\u0006$\b%A\npkR\u0004X\u000f\u001e+j[\u0016\u001cH/Y7q)f\u0004X-\u0006\u0002\u0002\fB!\u0011QRAP\u001d\u0011\ty)!'\u000f\t\u0005E\u0015QS\u0007\u0003\u0003'S!a_0\n\t\u0005]\u00151S\u0001\b'Fc5i\u001c8g\u0013\u0011\tY*!(\u00025A\u000b'/];fi>+H\u000f];u)&lWm\u001d;b[B$\u0016\u0010]3\u000b\t\u0005]\u00151S\u0005\u0005\u0003C\u000b\u0019KA\u0003WC2,X-\u0003\u0003\u0002&\u0006-!aC#ok6,'/\u0019;j_:\fqc\\;uaV$H+[7fgR\fW\u000e\u001d+za\u0016|F%Z9\u0015\t\u0005\u0015\u00121\u0016\u0005\n\u0003\u0003\u0002\u0012\u0011!a\u0001\u0003\u0017\u000bAc\\;uaV$H+[7fgR\fW\u000e\u001d+za\u0016\u0004\u0013a\u0004;j[\u0016\u001cH/Y7q\u0005V4g-\u001a:\u0016\u0005\u0005M\u0006CBA\u0005\u0003\u0017\n)\f\u0005\u0003\u0002\n\u0005]\u0016\u0002BA]\u0003\u0017\u0011AAQ=uK\u0006\u0001B/[7fgR\fW\u000e\u001d\"vM\u001a,'\u000fI\u0001\u000eI\u0016\u001c\u0017.\\1m\u0005V4g-\u001a:\u0002\u001d\u0011,7-[7bY\n+hMZ3sA\u0005\u0011B-\u0019;fi&lWMU3cCN,Wj\u001c3f+\t\t)\r\u0005\u0003\u0002H\u0006}e\u0002BAe\u0003KtA!a3\u0002\u0016:!\u0011QZAr\u001d\u0011\ty-!9\u000f\t\u0005E\u0017q\u001c\b\u0005\u0003'\fiN\u0004\u0003\u0002V\u0006mWBAAl\u0015\r\tInZ\u0001\u0007yI|w\u000e\u001e \n\u0003\u0019L!\u0001Z3\n\u0005\t\u001c\u0017B\u00011b\u0013\tYx,\u0003\u0003\u0002h\u0006u\u0015\u0001\u0006'fO\u0006\u001c\u0017PQ3iCZLwN\u001d)pY&\u001c\u00170A\neCR,G/[7f%\u0016\u0014\u0017m]3N_\u0012,\u0007%\u0001\beCR,'+\u001a2bg\u00164UO\\2\u0016\u0005\u0005=\b\u0003CA\u0005\u0003c\fy\"a\b\n\t\u0005M\u00181\u0002\u0002\n\rVt7\r^5p]F\nq\u0002Z1uKJ+'-Y:f\rVt7\rI\u0001\u0014i&lWm\u001d;b[B\u0014VMY1tK\u001a+hnY\u000b\u0003\u0003w\u0004\u0002\"!\u0003\u0002r\u0006u\u0018Q \t\u0005\u0003\u0013\ty0\u0003\u0003\u0003\u0002\u0005-!\u0001\u0002'p]\u001e\fA\u0003^5nKN$\u0018-\u001c9SK\n\f7/\u001a$v]\u000e\u0004\u0013aD5oif2$+\u001a2bg\u0016lu\u000eZ3\u0002!%tG/\u000f\u001cSK\n\f7/Z'pI\u0016\u0004\u0013aD5oif2$+\u001a2bg\u00164UO\\2\u0002!%tG/\u000f\u001cSK\n\f7/\u001a$v]\u000e\u0004\u0013!F4f_6,GO]=D_2,XN\\%oM>l\u0015\r]\u000b\u0003\u0005#\u0001\u0002Ba\u0005\u0003\u001e\u0005}!\u0011E\u0007\u0003\u0005+QAAa\u0006\u0003\u001a\u00059Q.\u001e;bE2,'\u0002\u0002B\u000e\u0003\u0017\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011yB!\u0006\u0003\u00075\u000b\u0007\u000fE\u0002\u0003$ir1A!\n8\u001d\u0011\u00119Ca\f\u000f\t\t%\"Q\u0006\b\u0005\u0003\u001b\u0014Y#\u0003\u0002_?&\u0011A,X\u0005\u00035n\u000bacR3p!\u0006\u0014\u0018/^3u/JLG/Z*vaB|'\u000f\u001e\t\u0004\u0003\u0007A4c\u0001\u001d\u00038A!\u0011\u0011\u0002B\u001d\u0013\u0011\u0011Y$a\u0003\u0003\r\u0005s\u0017PU3g)\t\u0011\u0019D\u0001\nHK>lW\r\u001e:z\u0007>dW/\u001c8J]\u001a|7c\u0001\u001e\u00038Q\u0011!Q\t\t\u0004\u0005\u000fRT\"\u0001\u001d\u0002\t\t\u0014w\u000e_\u000b\u0003\u0005\u001b\u00022Aa\u0012B\u0005e9Um\\7fiJL8i\u001c7v[:\u0014u.\u001e8eS:<'i\u001c=\u0014\u0007\u0005\u00139$\u0001\u0003nS:DVC\u0001B,!\u0011\tIA!\u0017\n\t\tm\u00131\u0002\u0002\u0007\t>,(\r\\3\u0002\u00115Lg\u000eW0%KF$B!!\n\u0003b!I\u0011\u0011I\"\u0002\u0002\u0003\u0007!qK\u0001\u0006[&t\u0007\fI\u0001\u0005[&t\u0017,\u0001\u0005nS:Lv\fJ3r)\u0011\t)Ca\u001b\t\u0013\u0005\u0005c)!AA\u0002\t]\u0013!B7j]f\u0003\u0013\u0001B7bqb\u000b\u0001\"\\1y1~#S-\u001d\u000b\u0005\u0003K\u0011)\bC\u0005\u0002B%\u000b\t\u00111\u0001\u0003X\u0005)Q.\u0019=YA\u0005!Q.\u0019=Z\u0003!i\u0017\r_-`I\u0015\fH\u0003BA\u0013\u0005\u007fB\u0011\"!\u0011M\u0003\u0003\u0005\rAa\u0016\u0002\u000b5\f\u00070\u0017\u0011\u0015\u0015\t5#Q\u0011BD\u0005\u0013\u0013Y\tC\u0005\u0003T9\u0003\n\u00111\u0001\u0003X!I!Q\r(\u0011\u0002\u0003\u0007!q\u000b\u0005\n\u0005_r\u0005\u0013!a\u0001\u0005/B\u0011B!\u001fO!\u0003\u0005\rAa\u0016\u0002\rU\u0004H-\u0019;f)\u0011\t)C!%\t\u000f\tMu\n1\u0001\u0003\u0016\u0006!q-Z8n!\u0011\u00119Ja)\u000e\u0005\te%\u0002\u0002BJ\u00057SAA!(\u0003 \u0006\u0019!\u000e^:\u000b\u0007\t\u0005V-\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007.\u0003\u0003\u0003&\ne%\u0001C$f_6,GO]=\u0002\u000b\t\u0014w\u000e\u001f\u0011\u0002#M,WM\\$f_6,GO]=UsB,7/\u0006\u0002\u0003.B1!1\u0003BX\u0005gKAA!-\u0003\u0016\t\u00191+\u001a;\u0011\t\tU&Q\u0018\b\u0005\u0005o\u0013I\f\u0005\u0003\u0002V\u0006-\u0011\u0002\u0002B^\u0003\u0017\ta\u0001\u0015:fI\u00164\u0017\u0002\u0002B`\u0005\u0003\u0014aa\u0015;sS:<'\u0002\u0002B^\u0003\u0017\t!c]3f]\u001e+w.\\3uef$\u0016\u0010]3tAQ!\u0011Q\u0005Bd\u0011\u001d\u0011\u0019\n\u0011a\u0001\u0005+\u000b\u0011dR3p[\u0016$(/_\"pYVlgNQ8v]\u0012Lgn\u001a\"pqB\u0019!qI)\u0014\u0007E\u00139\u0004\u0006\u0002\u0003L\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*\"A!6+\t\t]#q[\u0016\u0003\u00053\u0004BAa7\u0003f6\u0011!Q\u001c\u0006\u0005\u0005?\u0014\t/A\u0005v]\u000eDWmY6fI*!!1]A\u0006\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005O\u0014iNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u0001\u001eO\u0016$8\u000b]1sWN\u000bH\u000eU1scV,GOU8x\u001b\u0016$\u0018\rZ1uCR!!1\u0017Bz\u0011\u001d\tYc\u0016a\u0001\u0003_\tacZ3p[\u0016$(/_\"pYVlg.\u00138g_6\u000b\u0007\u000fI\u0001\u0012O\u0016|\u0007+\u0019:rk\u0016$h+\u001a:tS>tWC\u0001B~!\u0019\tIA!@\u00034&!!q`A\u0006\u0005\u0019y\u0005\u000f^5p]\u0006)r-Z8QCJ\fX/\u001a;WKJ\u001c\u0018n\u001c8`I\u0015\fH\u0003BA\u0013\u0007\u000bA\u0011\"!\u0011$\u0003\u0003\u0005\rAa?\u0002%\u001d,w\u000eU1scV,GOV3sg&|g\u000eI\u0001\u0015I\u00164\u0017-\u001e7u\u000f\u0016|\u0007+\u0019:rk\u0016$8I]:\u0016\u0005\r5\u0001CBA\u0005\u0005{\u001cy\u0001\u0005\u0003\u0004\u0012\r}a\u0002BB\n\u00073qA!a5\u0004\u0016%\u00191qC3\u0002\r)\u001cxN\u001c\u001bt\u0013\u0011\u0019Yb!\b\u0002\u000fA\f7m[1hK*\u00191qC3\n\t\r\u000521\u0005\u0002\u0007\u0015Z\u000bG.^3\u000b\t\rm1QD\u0001\u0019I\u00164\u0017-\u001e7u\u000f\u0016|\u0007+\u0019:rk\u0016$8I]:`I\u0015\fH\u0003BA\u0013\u0007SA\u0011\"!\u0011'\u0003\u0003\u0005\ra!\u0004\u0002+\u0011,g-Y;mi\u001e+w\u000eU1scV,Go\u0011:tA\u00051r-Z8QCJ\fX/\u001a;D_2,XN\\\"sg6\u000b\u0007/\u0006\u0002\u00042AA!1\u0003B\u000f\u0005g\u001bi!A\fhK>\u0004\u0016M]9vKR\u001cu\u000e\\;n]\u000e\u00138/T1qA\u0005!\u0011N\\5u)\u0011\u0019Ida\u0015\u0011\t\rm2Q\n\b\u0005\u0007{\u0019IE\u0004\u0003\u0004@\r\u001dc\u0002BB!\u0007\u000brA!!5\u0004D%\u0011!lY\u0005\u0003]>L!\u0001\\7\n\u0007\r-3.\u0001\u0007Xe&$XmU;qa>\u0014H/\u0003\u0003\u0004P\rE#\u0001D,sSR,7i\u001c8uKb$(bAB&W\"91Q\u000b\u0016A\u0002\r]\u0013!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0003\u0004Z\r\u0005TBAB.\u0015\u0011\u0019ifa\u0018\u0002\t\r|gN\u001a\u0006\u0003]\u000eLAaa\u0019\u0004\\\ti1i\u001c8gS\u001e,(/\u0019;j_:\fq\u0002\u001d:fa\u0006\u0014XMR8s/JLG/\u001a\u000b\u0005\u0003K\u0019I\u0007C\u0004\u0002\\-\u0002\r!a\u0018\u0002\u001b\u0019Lg.\u00197ju\u0016<&/\u001b;f)\t\u0019y\u0007\u0005\u0003\u0004r\rMdb\u00016\u0004J%!1QOB)\u0005U1\u0015N\\1mSj,Gm\u0016:ji\u0016\u001cuN\u001c;fqR\fQa\u001e:ji\u0016$B!!\n\u0004|!11QP\u0017A\u0002I\f1A]8x\u0003-9(/\u001b;f\r&,G\u000eZ:\u0015\u0011\u0005\u001521QBC\u0007\u000fCaa! /\u0001\u0004\u0011\bbBA\u0016]\u0001\u0007\u0011q\u0006\u0005\b\u0007\u0013s\u0003\u0019AA%\u000311\u0017.\u001a7e/JLG/\u001a:t\u0003)i\u0017m[3Xe&$XM\u001d\u000b\u0007\u0003\u001f\u001ayi!'\t\u000f\rEu\u00061\u0001\u0004\u0014\u0006AA-\u0019;b)f\u0004X\r\u0005\u0003\u00022\rU\u0015\u0002BBL\u0003g\u0011\u0001\u0002R1uCRK\b/\u001a\u0005\n\u00077{\u0003\u0013!a\u0001\u0007;\u000b1B]8pi>\u0013H-\u001b8bYB1\u0011\u0011\u0002B\u007f\u0003?\tA#\\1lK^\u0013\u0018\u000e^3sI\u0011,g-Y;mi\u0012\u0012TCABRU\u0011\u0019iJa6\u0002#5\f7.\u001a#fG&l\u0017\r\\,sSR,'\u000f\u0006\u0004\u0002P\r%6Q\u0016\u0005\b\u0007W\u000b\u0004\u0019AA\u0010\u0003%\u0001(/Z2jg&|g\u000eC\u0004\u00040F\u0002\r!a\b\u0002\u000bM\u001c\u0017\r\\3\u0002\u001f5\f7.Z!se\u0006LxK]5uKJ$B!a\u0014\u00046\"91q\u0017\u001aA\u0002\re\u0016!C1se\u0006LH+\u001f9f!\u0011\t\tda/\n\t\ru\u00161\u0007\u0002\n\u0003J\u0014\u0018-\u001f+za\u0016\fQ\"\\1lK6\u000b\u0007o\u0016:ji\u0016\u0014H\u0003BA(\u0007\u0007Dqa!24\u0001\u0004\u00199-A\u0004nCB$\u0016\u0010]3\u0011\t\u0005E2\u0011Z\u0005\u0005\u0007\u0017\f\u0019DA\u0004NCB$\u0016\u0010]3\u0002\u001d\r|gn];nK6+7o]1hKR!\u0011QEBi\u0011!\u0019\u0019\u000e\u000eCA\u0002\rU\u0017!\u00014\u0011\r\u0005%1q[A\u0013\u0013\u0011\u0019I.a\u0003\u0003\u0011q\u0012\u0017P\\1nKz\nAbY8ogVlWm\u0012:pkB$B!!\n\u0004`\"A11[\u001b\u0005\u0002\u0004\u0019).\u0001\u0007d_:\u001cX/\\3GS\u0016dG\r\u0006\u0004\u0004f\u000e%8Q\u001e\u000b\u0005\u0003K\u00199\u000f\u0003\u0005\u0004TZ\"\t\u0019ABk\u0011\u001d\u0019YO\u000ea\u0001\u0005g\u000bQAZ5fY\u0012Dqaa<7\u0001\u0004\ty\"A\u0003j]\u0012,\u0007\u0010")
public class GeoParquetWriteSupport
extends WriteSupport<InternalRow>
implements Logging {
    private StructType schema;
    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters;
    private RecordConsumer recordConsumer;
    private boolean writeLegacyParquetFormat;
    private Enumeration.Value outputTimestampType;
    private final byte[] timestampBuffer;
    private final byte[] decimalBuffer;
    private final Enumeration.Value datetimeRebaseMode;
    private final Function1<Object, Object> dateRebaseFunc;
    private final Function1<Object, Object> timestampRebaseFunc;
    private final Enumeration.Value int96RebaseMode;
    private final Function1<Object, Object> int96RebaseFunc;
    private final scala.collection.mutable.Map<Object, GeometryColumnInfo> geometryColumnInfoMap;
    private Option<String> geoParquetVersion;
    private Option<JsonAST.JValue> defaultGeoParquetCrs;
    private final scala.collection.mutable.Map<String, Option<JsonAST.JValue>> geoParquetColumnCrsMap;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private StructType schema() {
        return this.schema;
    }

    private void schema_$eq(StructType x$1) {
        this.schema = x$1;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters() {
        return this.rootFieldWriters;
    }

    private void rootFieldWriters_$eq(Function2<SpecializedGetters, Object, BoxedUnit>[] x$1) {
        this.rootFieldWriters = x$1;
    }

    private RecordConsumer recordConsumer() {
        return this.recordConsumer;
    }

    private void recordConsumer_$eq(RecordConsumer x$1) {
        this.recordConsumer = x$1;
    }

    private boolean writeLegacyParquetFormat() {
        return this.writeLegacyParquetFormat;
    }

    private void writeLegacyParquetFormat_$eq(boolean x$1) {
        this.writeLegacyParquetFormat = x$1;
    }

    private Enumeration.Value outputTimestampType() {
        return this.outputTimestampType;
    }

    private void outputTimestampType_$eq(Enumeration.Value x$1) {
        this.outputTimestampType = x$1;
    }

    private byte[] timestampBuffer() {
        return this.timestampBuffer;
    }

    private byte[] decimalBuffer() {
        return this.decimalBuffer;
    }

    private Enumeration.Value datetimeRebaseMode() {
        return this.datetimeRebaseMode;
    }

    private Function1<Object, Object> dateRebaseFunc() {
        return this.dateRebaseFunc;
    }

    private Function1<Object, Object> timestampRebaseFunc() {
        return this.timestampRebaseFunc;
    }

    private Enumeration.Value int96RebaseMode() {
        return this.int96RebaseMode;
    }

    private Function1<Object, Object> int96RebaseFunc() {
        return this.int96RebaseFunc;
    }

    private scala.collection.mutable.Map<Object, GeometryColumnInfo> geometryColumnInfoMap() {
        return this.geometryColumnInfoMap;
    }

    private Option<String> geoParquetVersion() {
        return this.geoParquetVersion;
    }

    private void geoParquetVersion_$eq(Option<String> x$1) {
        this.geoParquetVersion = x$1;
    }

    private Option<JsonAST.JValue> defaultGeoParquetCrs() {
        return this.defaultGeoParquetCrs;
    }

    private void defaultGeoParquetCrs_$eq(Option<JsonAST.JValue> x$1) {
        this.defaultGeoParquetCrs = x$1;
    }

    private scala.collection.mutable.Map<String, Option<JsonAST.JValue>> geoParquetColumnCrsMap() {
        return this.geoParquetColumnCrsMap;
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        Some some;
        Some some2;
        String schemaString = configuration.get(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA());
        this.schema_$eq(StructType$.MODULE$.fromString(schemaString));
        Predef$.MODULE$.assert(configuration.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()) != null);
        this.writeLegacyParquetFormat_$eq(StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(configuration.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()))));
        String key = SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key();
        Predef$.MODULE$.assert(configuration.get(key) != null);
        this.outputTimestampType_$eq(SQLConf.ParquetOutputTimestampType$.MODULE$.withName(configuration.get(key)));
        this.rootFieldWriters_$eq((Function2[])((IterableOnceOps)((IterableOps)this.schema().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField field = (StructField)tuple2._1();
                int ordinal = tuple2._2$mcI$sp();
                return this.makeWriter(field.dataType(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)ordinal)));
            }
            throw new MatchError((Object)tuple2);
        })).toArray(ClassTag$.MODULE$.apply(Function2.class)));
        if (this.geometryColumnInfoMap().isEmpty()) {
            throw new RuntimeException("No geometry column found in the schema");
        }
        String string = configuration.get(GeoParquetMetaData$.MODULE$.GEOPARQUET_VERSION_KEY());
        if (string == null) {
            some2 = new Some((Object)GeoParquetMetaData$.MODULE$.VERSION());
        } else if (string != null) {
            String string2 = string;
            some2 = new Some((Object)string2);
        } else {
            throw new MatchError((Object)string);
        }
        this.geoParquetVersion_$eq((Option<String>)some2);
        String string3 = configuration.get(GeoParquetMetaData$.MODULE$.GEOPARQUET_CRS_KEY());
        if (string3 == null) {
            some = new Some((Object)org.json4s.package$.MODULE$.JNull());
        } else if ("".equals(string3)) {
            some = None$.MODULE$;
        } else if (string3 != null) {
            String string4 = string3;
            some = new Some((Object)JsonMethods$.MODULE$.parse(org.json4s.package$.MODULE$.string2JsonInput(string4), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()));
        } else {
            throw new MatchError((Object)string3);
        }
        this.defaultGeoParquetCrs_$eq((Option<JsonAST.JValue>)some);
        ((IterableOnceOps)this.geometryColumnInfoMap().keys().map((Function1 & Serializable)x$6 -> GeoParquetWriteSupport.$anonfun$init$2(this, BoxesRunTime.unboxToInt((Object)x$6)))).foreach((Function1 & Serializable)name -> {
            GeoParquetWriteSupport.$anonfun$init$3(this, configuration, name);
            return BoxedUnit.UNIT;
        });
        MessageType messageType = new SparkToParquetSchemaConverter(configuration).convert(this.schema());
        String sparkSqlParquetRowMetadata = GeoParquetWriteSupport$.MODULE$.org$apache$spark$sql$execution$datasources$parquet$GeoParquetWriteSupport$$getSparkSqlParquetRowMetadata(this.schema());
        Enumeration.Value value = this.datetimeRebaseMode();
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
        Enumeration.Value value3 = this.int96RebaseMode();
        Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
        scala.collection.immutable.Map metadata = (scala.collection.immutable.Map)((MapOps)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.SPARK_VERSION_METADATA_KEY()), (Object)org.apache.spark.package$.MODULE$.SPARK_VERSION_SHORT()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ParquetReadSupport$.MODULE$.SPARK_METADATA_KEY()), (Object)sparkSqlParquetRowMetadata)}))).$plus$plus((IterableOnce)(!(value != null ? !value.equals(value2) : value2 != null) ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.legacyDateTime"), (Object)"")) : None$.MODULE$))).$plus$plus((IterableOnce)(!(value3 != null ? !value3.equals(value4) : value4 != null) ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.legacyINT96"), (Object)"")) : None$.MODULE$));
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(134).append("Initialized Parquet WriteSupport with Catalyst schema:\n         |").append(this.schema().prettyJson()).append("\n         |and corresponding Parquet message type:\n         |").append(messageType).append("\n       ").toString())));
        return new WriteSupport.WriteContext(messageType, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)metadata).asJava());
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer_$eq(recordConsumer);
    }

    public WriteSupport.FinalizedWriteContext finalizeWrite() {
        Object object;
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (this.geometryColumnInfoMap().nonEmpty()) {
            int primaryColumnIndex = BoxesRunTime.unboxToInt((Object)this.geometryColumnInfoMap().keys().head());
            String primaryColumn = this.schema().fields()[primaryColumnIndex].name();
            scala.collection.immutable.Map columns = this.geometryColumnInfoMap().map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    int ordinal = tuple2._1$mcI$sp();
                    GeometryColumnInfo columnInfo = (GeometryColumnInfo)tuple2._2();
                    String columnName = this.schema().fields()[ordinal].name();
                    Seq geometryTypes = columnInfo.seenGeometryTypes().toSeq();
                    Seq bbox = geometryTypes.nonEmpty() ? (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{columnInfo.bbox().minX(), columnInfo.bbox().minY(), columnInfo.bbox().maxX(), columnInfo.bbox().maxY()})) : (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 0.0, 0.0}));
                    Option crs = (Option)this.geoParquetColumnCrsMap().getOrElse((Object)columnName, (Function0 & Serializable)() -> this.defaultGeoParquetCrs());
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)columnName), (Object)new GeometryFieldMetaData("WKB", geometryTypes, bbox, crs));
                }
                throw new MatchError((Object)tuple2);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            GeoParquetMetaData geoParquetMetadata = new GeoParquetMetaData(this.geoParquetVersion(), primaryColumn, columns);
            String geoParquetMetadataJson = GeoParquetMetaData$.MODULE$.toJson(geoParquetMetadata);
            object = metadata.put("geo", geoParquetMetadataJson);
        } else {
            object = BoxedUnit.UNIT;
        }
        return new WriteSupport.FinalizedWriteContext(metadata);
    }

    public void write(InternalRow row) {
        this.consumeMessage((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.writeFields(row, this.schema(), this.rootFieldWriters()));
    }

    private void writeFields(InternalRow row, StructType schema, Function2<SpecializedGetters, Object, BoxedUnit>[] fieldWriters) {
        IntRef i = IntRef.create((int)0);
        while (i.elem < row.numFields()) {
            if (!row.isNullAt(i.elem)) {
                this.consumeField(schema.apply(i.elem).name(), i.elem, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> fieldWriters[i$1.elem].apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)i$1.elem)));
            }
            ++i.elem;
        }
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeWriter(DataType dataType, Option<Object> rootOrdinal) {
        while (true) {
            DecimalType decimalType;
            Option option;
            DataType dataType2;
            if (BooleanType$.MODULE$.equals(dataType2 = dataType)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$1(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (ByteType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$2(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (ShortType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$3(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (DateType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$4(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (IntegerType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$5(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (LongType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$6(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (FloatType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$7(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (DoubleType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$8(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (StringType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$9(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (TimestampType$.MODULE$.equals(dataType2)) {
                Enumeration.Value value = this.outputTimestampType();
                Enumeration.Value value2 = SQLConf.ParquetOutputTimestampType$.MODULE$.INT96();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    return (Function2 & Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$10(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                }
                Enumeration.Value value4 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MICROS();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    return (Function2 & Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$11(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                }
                Enumeration.Value value6 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MILLIS();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    return (Function2 & Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$12(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                }
                throw new MatchError((Object)value);
            }
            if (BinaryType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$13(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType2 instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType2)).isEmpty()) {
                int precision = ((Tuple2)option.get())._1$mcI$sp();
                int scale = ((Tuple2)option.get())._2$mcI$sp();
                return this.makeDecimalWriter(precision, scale);
            }
            if (dataType2 instanceof StructType) {
                StructType structType = (StructType)dataType2;
                Function2[] fieldWriters = (Function2[])((IterableOnceOps)((IterableOps)structType.map((Function1 & Serializable)x$8 -> x$8.dataType())).map((Function1 & Serializable)x$9 -> this.makeWriter((DataType)x$9, (Option<Object>)None$.MODULE$))).toArray(ClassTag$.MODULE$.apply(Function2.class));
                return (Function2 & Serializable)(row, ordinal) -> {
                    this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.writeFields(row.getStruct(BoxesRunTime.unboxToInt((Object)ordinal), structType.length()), structType, fieldWriters));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType2 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType2;
                return this.makeArrayWriter(arrayType);
            }
            if (dataType2 instanceof MapType) {
                MapType mapType = (MapType)dataType2;
                return this.makeMapWriter(mapType);
            }
            if (GeometryUDT$.MODULE$.equals(dataType2)) {
                GeometryColumnInfo geometryColumnInfo;
                Option<Object> option2 = rootOrdinal;
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    int ordinal2 = BoxesRunTime.unboxToInt((Object)some.value());
                    geometryColumnInfo = (GeometryColumnInfo)this.geometryColumnInfoMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)ordinal2), (Function0 & Serializable)() -> new GeometryColumnInfo());
                } else if (None$.MODULE$.equals(option2)) {
                    geometryColumnInfo = null;
                } else {
                    throw new MatchError(option2);
                }
                GeometryColumnInfo geometryColumnInfo2 = geometryColumnInfo;
                return (Function2 & Serializable)(row, ordinal) -> {
                    GeoParquetWriteSupport.$anonfun$makeWriter$19(this, geometryColumnInfo2, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (!(dataType2 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            rootOrdinal = this.makeWriter$default$2();
            dataType = userDefinedType.sqlType();
        }
        throw scala.sys.package$.MODULE$.error(new StringBuilder(23).append("Unsupported data type ").append(dataType).append(".").toString());
    }

    private Option<Object> makeWriter$default$2() {
        return None$.MODULE$;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeDecimalWriter(int precision, int scale) {
        Predef$.MODULE$.assert(precision <= DecimalType$.MODULE$.MAX_PRECISION(), (Function0 & Serializable)() -> new StringBuilder(41).append("Decimal precision ").append(precision).append(" exceeds max precision ").append(DecimalType$.MODULE$.MAX_PRECISION()).toString());
        int numBytes = Decimal$.MODULE$.minBytesForPrecision()[precision];
        Function2 & Serializable int32Writer = (Function2 & Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeDecimalWriter$2(this, precision, scale, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable int64Writer = (Function2 & Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeDecimalWriter$3(this, precision, scale, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable binaryWriterUsingUnscaledLong = (Function2 & Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeDecimalWriter$4(this, precision, scale, numBytes, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable binaryWriterUsingUnscaledBytes = (Function2 & Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeDecimalWriter$5(this, precision, scale, numBytes, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this.writeLegacyParquetFormat();
        if (!bl3) {
            bl = true;
            bl2 = bl3;
            if (precision <= Decimal$.MODULE$.MAX_INT_DIGITS()) {
                return int32Writer;
            }
        }
        if (bl && precision <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            return int64Writer;
        }
        if (bl3 && precision <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            return binaryWriterUsingUnscaledLong;
        }
        return binaryWriterUsingUnscaledBytes;
    }

    public Function2<SpecializedGetters, Object, BoxedUnit> makeArrayWriter(ArrayType arrayType) {
        boolean bl;
        Function2<SpecializedGetters, Object, BoxedUnit> elementWriter = this.makeWriter(arrayType.elementType(), this.makeWriter$default$2());
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(this.writeLegacyParquetFormat(), arrayType.containsNull());
        if (sp2 != null && !(bl = sp2._1$mcZ$sp())) {
            return this.threeLevelArrayWriter$1("list", "element", elementWriter);
        }
        if (sp2 != null) {
            boolean bl2 = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl2 && bl3) {
                return this.threeLevelArrayWriter$1("bag", "array", elementWriter);
            }
        }
        if (sp2 != null) {
            boolean bl4 = sp2._1$mcZ$sp();
            boolean bl5 = sp2._2$mcZ$sp();
            if (bl4 && !bl5) {
                return this.twoLevelArrayWriter$1("array", elementWriter);
            }
        }
        throw new MatchError((Object)sp2);
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeMapWriter(MapType mapType) {
        Function2<SpecializedGetters, Object, BoxedUnit> keyWriter = this.makeWriter(mapType.keyType(), this.makeWriter$default$2());
        Function2<SpecializedGetters, Object, BoxedUnit> valueWriter = this.makeWriter(mapType.valueType(), this.makeWriter$default$2());
        String repeatedGroupName = this.writeLegacyParquetFormat() ? "map" : "key_value";
        return (Function2 & Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeMapWriter$1(this, repeatedGroupName, keyWriter, valueWriter, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    private void consumeMessage(Function0<BoxedUnit> f) {
        this.recordConsumer().startMessage();
        f.apply$mcV$sp();
        this.recordConsumer().endMessage();
    }

    private void consumeGroup(Function0<BoxedUnit> f) {
        this.recordConsumer().startGroup();
        f.apply$mcV$sp();
        this.recordConsumer().endGroup();
    }

    private void consumeField(String field, int index, Function0<BoxedUnit> f) {
        this.recordConsumer().startField(field, index);
        f.apply$mcV$sp();
        this.recordConsumer().endField(field, index);
    }

    public static final /* synthetic */ String $anonfun$init$2(GeoParquetWriteSupport $this, int x$6) {
        return $this.schema().apply(x$6).name();
    }

    public static final /* synthetic */ void $anonfun$init$3(GeoParquetWriteSupport $this, Configuration configuration$1, String name) {
        Option$.MODULE$.apply((Object)configuration$1.get(new StringBuilder(1).append(GeoParquetMetaData$.MODULE$.GEOPARQUET_CRS_KEY()).append(".").append(name).toString())).foreach((Function1 & Serializable)x0$2 -> {
            String string = x0$2;
            if ("".equals(string)) {
                return $this.geoParquetColumnCrsMap().put((Object)name, (Object)None$.MODULE$);
            }
            if (string != null) {
                String string2 = string;
                return $this.geoParquetColumnCrsMap().put((Object)name, (Object)new Some((Object)JsonMethods$.MODULE$.parse(org.json4s.package$.MODULE$.string2JsonInput(string2), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())));
            }
            throw new MatchError((Object)string);
        });
    }

    public static final /* synthetic */ void $anonfun$makeWriter$1(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBoolean(row.getBoolean(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$2(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger((int)row.getByte(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$3(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger((int)row.getShort(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$4(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger($this.dateRebaseFunc().apply$mcII$sp(row.getInt(ordinal)));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$5(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger(row.getInt(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$6(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addLong(row.getLong(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$7(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addFloat(row.getFloat(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$8(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addDouble(row.getDouble(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$9(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])row.getUTF8String(ordinal).getBytes()));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$10(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = $this.int96RebaseFunc().apply$mcJJ$sp(row.getLong(ordinal));
        Tuple2 tuple2 = DateTimeUtils$.MODULE$.toJulianDay(micros);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int julianDay = tuple2._1$mcI$sp();
        long timeOfDayNanos = tuple2._2$mcJ$sp();
        Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(julianDay, timeOfDayNanos);
        int julianDay2 = sp2._1$mcI$sp();
        long timeOfDayNanos2 = sp2._2$mcJ$sp();
        ByteBuffer buf = ByteBuffer.wrap($this.timestampBuffer());
        buf.order(ByteOrder.LITTLE_ENDIAN).putLong(timeOfDayNanos2).putInt(julianDay2);
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])$this.timestampBuffer()));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$11(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = row.getLong(ordinal);
        $this.recordConsumer().addLong($this.timestampRebaseFunc().apply$mcJJ$sp(micros));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$12(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = row.getLong(ordinal);
        long millis = DateTimeUtils$.MODULE$.microsToMillis($this.timestampRebaseFunc().apply$mcJJ$sp(micros));
        $this.recordConsumer().addLong(millis);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$13(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])row.getBinary(ordinal)));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$19(GeoParquetWriteSupport $this, GeometryColumnInfo geometryColumnInfo$1, SpecializedGetters row, int ordinal) {
        byte[] serializedGeometry = row.getBinary(ordinal);
        Geometry geom = GeometryUDT$.MODULE$.deserialize((Object)serializedGeometry);
        WKBWriter wkbWriter = new WKBWriter(GeomUtils.getDimension((Geometry)geom));
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])wkbWriter.write(geom)));
        if (geometryColumnInfo$1 != null) {
            geometryColumnInfo$1.update(geom);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$2(GeoParquetWriteSupport $this, int precision$1, int scale$1, SpecializedGetters row, int ordinal) {
        long unscaledLong = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        $this.recordConsumer().addInteger((int)unscaledLong);
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$3(GeoParquetWriteSupport $this, int precision$1, int scale$1, SpecializedGetters row, int ordinal) {
        long unscaledLong = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        $this.recordConsumer().addLong(unscaledLong);
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$4(GeoParquetWriteSupport $this, int precision$1, int scale$1, int numBytes$1, SpecializedGetters row, int ordinal) {
        long unscaled = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        int i = 0;
        int shift = 8 * (numBytes$1 - 1);
        while (i < numBytes$1) {
            $this.decimalBuffer()[i] = (byte)(unscaled >> shift);
            ++i;
            shift -= 8;
        }
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])$this.decimalBuffer(), (int)0, (int)numBytes$1));
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$5(GeoParquetWriteSupport $this, int precision$1, int scale$1, int numBytes$1, SpecializedGetters row, int ordinal) {
        byte[] byArray;
        Decimal decimal = row.getDecimal(ordinal, precision$1, scale$1);
        byte[] bytes = decimal.toJavaBigDecimal().unscaledValue().toByteArray();
        if (bytes.length == numBytes$1) {
            byArray = bytes;
        } else {
            byte signByte = BoxesRunTime.unboxToByte((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.byteArrayOps(bytes))) < 0 ? (byte)-1 : 0;
            Arrays.fill($this.decimalBuffer(), 0, numBytes$1 - bytes.length, signByte);
            System.arraycopy(bytes, 0, $this.decimalBuffer(), numBytes$1 - bytes.length, bytes.length);
            byArray = $this.decimalBuffer();
        }
        byte[] fixedLengthBytes = byArray;
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])fixedLengthBytes, (int)0, (int)numBytes$1));
    }

    public static final /* synthetic */ void $anonfun$makeArrayWriter$1(GeoParquetWriteSupport $this, String repeatedGroupName$1, String elementFieldName$1, Function2 elementWriter$1, SpecializedGetters row, int ordinal) {
        ArrayData array = row.getArray(ordinal);
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            if (array.numElements() > 0) {
                $this.consumeField(repeatedGroupName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    IntRef i = IntRef.create((int)0);
                    while (i.elem < array.numElements()) {
                        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                            if (!array.isNullAt(i$2.elem)) {
                                $this.consumeField(elementFieldName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> elementWriter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i$2.elem)));
                                return;
                            }
                        });
                        ++i.elem;
                    }
                });
                return;
            }
        });
    }

    private final Function2 threeLevelArrayWriter$1(String repeatedGroupName, String elementFieldName, Function2 elementWriter$1) {
        return (Function2 & Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeArrayWriter$1(this, repeatedGroupName, elementFieldName, elementWriter$1, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ void $anonfun$makeArrayWriter$6(GeoParquetWriteSupport $this, String repeatedFieldName$1, Function2 elementWriter$1, SpecializedGetters row, int ordinal) {
        ArrayData array = row.getArray(ordinal);
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            if (array.numElements() > 0) {
                $this.consumeField(repeatedFieldName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    for (int i = 0; i < array.numElements(); ++i) {
                        elementWriter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i));
                    }
                });
                return;
            }
        });
    }

    private final Function2 twoLevelArrayWriter$1(String repeatedFieldName, Function2 elementWriter$1) {
        return (Function2 & Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeArrayWriter$6(this, repeatedFieldName, elementWriter$1, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ void $anonfun$makeMapWriter$1(GeoParquetWriteSupport $this, String repeatedGroupName$2, Function2 keyWriter$1, Function2 valueWriter$1, SpecializedGetters row, int ordinal) {
        MapData map = row.getMap(ordinal);
        ArrayData keyArray = map.keyArray();
        ArrayData valueArray = map.valueArray();
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            if (map.numElements() > 0) {
                $this.consumeField(repeatedGroupName$2, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    IntRef i = IntRef.create((int)0);
                    while (i.elem < map.numElements()) {
                        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                            $this.consumeField("key", 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> keyWriter$1.apply((Object)keyArray, (Object)BoxesRunTime.boxToInteger((int)i$3.elem)));
                            if (!map.valueArray().isNullAt(i$3.elem)) {
                                $this.consumeField("value", 1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> valueWriter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i$3.elem)));
                                return;
                            }
                        });
                        ++i.elem;
                    }
                });
                return;
            }
        });
    }

    public GeoParquetWriteSupport() {
        Logging.$init$((Logging)this);
        this.timestampBuffer = new byte[12];
        this.decimalBuffer = new byte[Decimal$.MODULE$.minBytesForPrecision()[DecimalType$.MODULE$.MAX_PRECISION()]];
        this.datetimeRebaseMode = SQLConf.LegacyBehaviorPolicy$.MODULE$.withName(SQLConf$.MODULE$.get().getConfString(GeoDataSourceUtils$.MODULE$.PARQUET_REBASE_MODE_IN_WRITE()));
        this.dateRebaseFunc = GeoDataSourceUtils$.MODULE$.creteDateRebaseFuncInWrite(this.datetimeRebaseMode(), "Parquet");
        this.timestampRebaseFunc = GeoDataSourceUtils$.MODULE$.creteTimestampRebaseFuncInWrite(this.datetimeRebaseMode(), "Parquet");
        this.int96RebaseMode = SQLConf.LegacyBehaviorPolicy$.MODULE$.withName(SQLConf$.MODULE$.get().getConfString(GeoDataSourceUtils$.MODULE$.PARQUET_INT96_REBASE_MODE_IN_WRITE()));
        this.int96RebaseFunc = GeoDataSourceUtils$.MODULE$.creteTimestampRebaseFuncInWrite(this.int96RebaseMode(), "Parquet INT96");
        this.geometryColumnInfoMap = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.geoParquetVersion = None$.MODULE$;
        this.defaultGeoParquetCrs = None$.MODULE$;
        this.geoParquetColumnCrsMap = (scala.collection.mutable.Map)Map$.MODULE$.empty();
    }

    public static class GeometryColumnBoundingBox {
        private double minX;
        private double minY;
        private double maxX;
        private double maxY;

        public double minX() {
            return this.minX;
        }

        public void minX_$eq(double x$1) {
            this.minX = x$1;
        }

        public double minY() {
            return this.minY;
        }

        public void minY_$eq(double x$1) {
            this.minY = x$1;
        }

        public double maxX() {
            return this.maxX;
        }

        public void maxX_$eq(double x$1) {
            this.maxX = x$1;
        }

        public double maxY() {
            return this.maxY;
        }

        public void maxY_$eq(double x$1) {
            this.maxY = x$1;
        }

        public void update(Geometry geom) {
            Envelope env = geom.getEnvelopeInternal();
            this.minX_$eq(scala.math.package$.MODULE$.min(this.minX(), env.getMinX()));
            this.minY_$eq(scala.math.package$.MODULE$.min(this.minY(), env.getMinY()));
            this.maxX_$eq(scala.math.package$.MODULE$.max(this.maxX(), env.getMaxX()));
            this.maxY_$eq(scala.math.package$.MODULE$.max(this.maxY(), env.getMaxY()));
        }

        public GeometryColumnBoundingBox(double minX, double minY, double maxX, double maxY) {
            this.minX = minX;
            this.minY = minY;
            this.maxX = maxX;
            this.maxY = maxY;
        }
    }

    public static class GeometryColumnInfo {
        private final GeometryColumnBoundingBox bbox = new GeometryColumnBoundingBox(GeoParquetWriteSupport$GeometryColumnBoundingBox$.MODULE$.$lessinit$greater$default$1(), GeoParquetWriteSupport$GeometryColumnBoundingBox$.MODULE$.$lessinit$greater$default$2(), GeoParquetWriteSupport$GeometryColumnBoundingBox$.MODULE$.$lessinit$greater$default$3(), GeoParquetWriteSupport$GeometryColumnBoundingBox$.MODULE$.$lessinit$greater$default$4());
        private final Set<String> seenGeometryTypes = (Set)Set$.MODULE$.empty();

        public GeometryColumnBoundingBox bbox() {
            return this.bbox;
        }

        public Set<String> seenGeometryTypes() {
            return this.seenGeometryTypes;
        }

        public void update(Geometry geom) {
            this.bbox().update(geom);
            Coordinate coordinate = geom.getCoordinate();
            boolean hasZ = coordinate != null ? !Double.isNaN(coordinate.getZ()) : false;
            String geometryType = !hasZ ? geom.getGeometryType() : new StringBuilder(2).append(geom.getGeometryType()).append(" Z").toString();
            this.seenGeometryTypes().add((Object)geometryType);
        }
    }
}

