/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.strategy.join;

import java.io.Serializable;
import org.apache.sedona.core.spatialRDD.SpatialRDD;
import org.apache.sedona.core.utils.SedonaConf;
import org.apache.sedona.sql.utils.GeometrySerializer$;
import org.apache.sedona.sql.utils.RasterSerializer$;
import org.apache.spark.api.java.JavaRDD$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.sedona_sql.UDT.RasterUDT;
import org.apache.spark.sql.sedona_sql.strategy.join.JoinedGeometry$;
import org.apache.spark.sql.sedona_sql.strategy.join.JoinedGeometryRaster$;
import org.geotools.coverage.grid.GridCoverage2D;
import org.locationtech.jts.geom.Geometry;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ea!C\u0004\t!\u0003\r\taFA\u0002\u0011\u0015q\u0002\u0001\"\u0001 \u0011\u0015\u0019\u0003\u0001\"\u0001%\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u0015I\u0007\u0001\"\u0001k\u0005I!&/Y5u\u0015>Lg.U;fef\u0014\u0015m]3\u000b\u0005%Q\u0011\u0001\u00026pS:T!a\u0003\u0007\u0002\u0011M$(/\u0019;fOfT!!\u0004\b\u0002\u0015M,Gm\u001c8b?N\fHN\u0003\u0002\u0010!\u0005\u00191/\u001d7\u000b\u0005E\u0011\u0012!B:qCJ\\'BA\n\u0015\u0003\u0019\t\u0007/Y2iK*\tQ#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00011A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\fa\u0001J5oSR$C#\u0001\u0011\u0011\u0005e\t\u0013B\u0001\u0012\u001b\u0005\u0011)f.\u001b;\u0002!Q|7\u000b]1uS\u0006d'\u000b\u001a3QC&\u0014H#B\u0013=\u0019F\u001b\u0006\u0003B\r'Q!J!a\n\u000e\u0003\rQ+\b\u000f\\33!\rI\u0003GM\u0007\u0002U)\u00111\u0006L\u0001\u000bgB\fG/[1m%\u0012#%BA\u0017/\u0003\u0011\u0019wN]3\u000b\u0005=\u0012\u0012AB:fI>t\u0017-\u0003\u00022U\tQ1\u000b]1uS\u0006d'\u000b\u0012#\u0011\u0005MRT\"\u0001\u001b\u000b\u0005U2\u0014\u0001B4f_6T!a\u000e\u001d\u0002\u0007)$8O\u0003\u0002:)\u0005aAn\\2bi&|g\u000e^3dQ&\u00111\b\u000e\u0002\t\u000f\u0016|W.\u001a;ss\")QH\u0001a\u0001}\u00059A.\u001a4u%\u0012$\u0007cA C\t6\t\u0001I\u0003\u0002B!\u0005\u0019!\u000f\u001a3\n\u0005\r\u0003%a\u0001*E\tB\u0011QIS\u0007\u0002\r*\u0011q\tS\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002J\u001d\u0005A1-\u0019;bYf\u001cH/\u0003\u0002L\r\nIQK\\:bM\u0016\u0014vn\u001e\u0005\u0006\u001b\n\u0001\rAT\u0001\u000eY\u00164Go\u00155ba\u0016,\u0005\u0010\u001d:\u0011\u0005\u0015{\u0015B\u0001)G\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0006%\n\u0001\rAP\u0001\te&<\u0007\u000e\u001e*eI\")AK\u0001a\u0001\u001d\u0006q!/[4iiNC\u0017\r]3FqB\u0014\u0018\u0001\u0004;p'B\fG/[1m%\u0012#Ec\u0001\u0015X1\")\u0011i\u0001a\u0001}!)\u0011l\u0001a\u0001\u001d\u0006y1\u000f[1qK\u0016C\bO]3tg&|g.\u0001\nu_^;5\u000b\u000f\u001bF]Z,Gn\u001c9f%\u0012#Ec\u0001\u0015];\")\u0011\t\u0002a\u0001}!)\u0011\f\u0002a\u0001\u001d\u0006)Bo\\#ya\u0006tG-\u001a3F]Z,Gn\u001c9f%\u0012#E#\u0002\u0015aC\n$\u0007\"B!\u0006\u0001\u0004q\u0004\"B-\u0006\u0001\u0004q\u0005\"B2\u0006\u0001\u0004q\u0015a\u00032pk:$'+\u00193jkNDQ!Z\u0003A\u0002\u0019\f1\"[:HK><'/\u00199isB\u0011\u0011dZ\u0005\u0003Qj\u0011qAQ8pY\u0016\fg.A\u000be_N\u0003\u0018\r^5bYB\u000b'\u000f^5uS>t\u0017N\\4\u0015\u000b\u0001ZWn\\=\t\u000b14\u0001\u0019\u0001\u0015\u0002\u001d\u0011|W.\u001b8b]R\u001c\u0006.\u00199fg\")aN\u0002a\u0001Q\u0005qam\u001c7m_^,'o\u00155ba\u0016\u001c\b\"\u00029\u0007\u0001\u0004\t\u0018!\u00048v[B\u000b'\u000f^5uS>t7\u000f\u0005\u0002so6\t1O\u0003\u0002uk\u0006!A.\u00198h\u0015\u00051\u0018\u0001\u00026bm\u0006L!\u0001_:\u0003\u000f%sG/Z4fe\")!P\u0002a\u0001w\u0006Q1/\u001a3p]\u0006\u001cuN\u001c4\u0011\u0005q|X\"A?\u000b\u0005yd\u0013!B;uS2\u001c\u0018bAA\u0001{\nQ1+\u001a3p]\u0006\u001cuN\u001c4\u0013\r\u0005\u0015\u0011\u0011BA\u0007\r\u0019\t9\u0001\u0001\u0001\u0002\u0004\taAH]3gS:,W.\u001a8u}A\u0019\u00111\u0002\u0001\u000e\u0003!\u0001B!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'q\u0011!C3yK\u000e,H/[8o\u0013\u0011\t9\"!\u0005\u0003\u0013M\u0003\u0018M]6QY\u0006t\u0007")
public interface TraitJoinQueryBase {
    public static /* synthetic */ Tuple2 toSpatialRddPair$(TraitJoinQueryBase $this, RDD leftRdd, Expression leftShapeExpr, RDD rightRdd, Expression rightShapeExpr) {
        return $this.toSpatialRddPair((RDD<UnsafeRow>)leftRdd, leftShapeExpr, (RDD<UnsafeRow>)rightRdd, rightShapeExpr);
    }

    default public Tuple2<SpatialRDD<Geometry>, SpatialRDD<Geometry>> toSpatialRddPair(RDD<UnsafeRow> leftRdd, Expression leftShapeExpr, RDD<UnsafeRow> rightRdd, Expression rightShapeExpr) {
        return leftShapeExpr.dataType() instanceof RasterUDT || rightShapeExpr.dataType() instanceof RasterUDT ? new Tuple2(this.toWGS84EnvelopeRDD(leftRdd, leftShapeExpr), this.toWGS84EnvelopeRDD(rightRdd, rightShapeExpr)) : new Tuple2(this.toSpatialRDD(leftRdd, leftShapeExpr), this.toSpatialRDD(rightRdd, rightShapeExpr));
    }

    public static /* synthetic */ SpatialRDD toSpatialRDD$(TraitJoinQueryBase $this, RDD rdd, Expression shapeExpression) {
        return $this.toSpatialRDD((RDD<UnsafeRow>)rdd, shapeExpression);
    }

    /*
     * WARNING - void declaration
     */
    default public SpatialRDD<Geometry> toSpatialRDD(RDD<UnsafeRow> rdd, Expression shapeExpression) {
        void var3_3;
        SpatialRDD spatialRdd = new SpatialRDD();
        spatialRdd.setRawSpatialRDD(rdd.map((Function1 & Serializable & scala.Serializable)x -> {
            void var2_2;
            Geometry shape = GeometrySerializer$.MODULE$.deserialize((byte[])shapeExpression.eval((InternalRow)x));
            shape.setUserData((Object)x.copy());
            return var2_2;
        }, ClassTag$.MODULE$.apply(Geometry.class)).toJavaRDD());
        return var3_3;
    }

    public static /* synthetic */ SpatialRDD toWGS84EnvelopeRDD$(TraitJoinQueryBase $this, RDD rdd, Expression shapeExpression) {
        return $this.toWGS84EnvelopeRDD((RDD<UnsafeRow>)rdd, shapeExpression);
    }

    /*
     * WARNING - void declaration
     */
    default public SpatialRDD<Geometry> toWGS84EnvelopeRDD(RDD<UnsafeRow> rdd, Expression shapeExpression) {
        void var3_3;
        SpatialRDD spatialRdd = new SpatialRDD();
        RDD wgs84EnvelopeRdd = shapeExpression.dataType() instanceof RasterUDT ? rdd.map((Function1 & Serializable & scala.Serializable)row -> {
            void var3_3;
            GridCoverage2D raster = RasterSerializer$.MODULE$.deserialize((byte[])shapeExpression.eval((InternalRow)row));
            Geometry shape = JoinedGeometryRaster$.MODULE$.rasterToWGS84Envelope(raster);
            shape.setUserData((Object)row.copy());
            return var3_3;
        }, ClassTag$.MODULE$.apply(Geometry.class)) : rdd.map((Function1 & Serializable & scala.Serializable)row -> {
            void var3_3;
            Geometry geom = GeometrySerializer$.MODULE$.deserialize((byte[])shapeExpression.eval((InternalRow)row));
            Geometry shape = JoinedGeometryRaster$.MODULE$.geometryToWGS84Envelope(geom);
            shape.setUserData((Object)row.copy());
            return var3_3;
        }, ClassTag$.MODULE$.apply(Geometry.class));
        spatialRdd.setRawSpatialRDD(JavaRDD$.MODULE$.fromRDD(wgs84EnvelopeRdd, ClassTag$.MODULE$.apply(Geometry.class)));
        return var3_3;
    }

    public static /* synthetic */ SpatialRDD toExpandedEnvelopeRDD$(TraitJoinQueryBase $this, RDD rdd, Expression shapeExpression, Expression boundRadius, boolean isGeography) {
        return $this.toExpandedEnvelopeRDD((RDD<UnsafeRow>)rdd, shapeExpression, boundRadius, isGeography);
    }

    default public SpatialRDD<Geometry> toExpandedEnvelopeRDD(RDD<UnsafeRow> rdd, Expression shapeExpression, Expression boundRadius, boolean isGeography) {
        SpatialRDD<Geometry> spatialRdd = new SpatialRDD<Geometry>();
        spatialRdd.setRawSpatialRDD(rdd.map((Function1 & Serializable & scala.Serializable)x -> {
            Geometry shape = GeometrySerializer$.MODULE$.deserialize((byte[])shapeExpression.eval((InternalRow)x));
            double distance = BoxesRunTime.unboxToDouble((Object)boundRadius.eval((InternalRow)x));
            Geometry expandedEnvelope = JoinedGeometry$.MODULE$.geometryToExpandedEnvelope(shape, distance, isGeography);
            expandedEnvelope.setUserData((Object)x.copy());
            return expandedEnvelope;
        }, ClassTag$.MODULE$.apply(Geometry.class)).toJavaRDD());
        return spatialRdd;
    }

    public static /* synthetic */ void doSpatialPartitioning$(TraitJoinQueryBase $this, SpatialRDD dominantShapes, SpatialRDD followerShapes, Integer numPartitions, SedonaConf sedonaConf) {
        $this.doSpatialPartitioning(dominantShapes, followerShapes, numPartitions, sedonaConf);
    }

    default public void doSpatialPartitioning(SpatialRDD<Geometry> dominantShapes, SpatialRDD<Geometry> followerShapes, Integer numPartitions, SedonaConf sedonaConf) {
        block0: {
            if (dominantShapes.approximateTotalCount <= 0L || Predef$.MODULE$.Integer2int(numPartitions) <= 0) break block0;
            dominantShapes.spatialPartitioning(sedonaConf.getJoinGridType(), Predef$.MODULE$.Integer2int(numPartitions));
            followerShapes.spatialPartitioning(dominantShapes.getPartitioner());
        }
    }

    public static void $init$(TraitJoinQueryBase $this) {
    }
}

