/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.showcase;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.sedona.common.enums.FileDataSplitter;
import org.apache.sedona.core.enums.IndexType;
import org.apache.sedona.core.formatMapper.EarthdataHDFPointMapper;
import org.apache.sedona.core.serde.SedonaKryoRegistrator;
import org.apache.sedona.core.spatialOperator.RangeQuery;
import org.apache.sedona.core.spatialRDD.PointRDD;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.storage.StorageLevel;
import org.locationtech.jts.geom.Envelope;

public class EarthdataMapperRunnableExample {
    public static JavaSparkContext sc;
    static String InputLocation;
    static FileDataSplitter splitter;
    static IndexType indexType;
    static Integer numPartitions;
    static Envelope queryEnvelope;
    static int loopTimes;
    static int HDFIncrement;
    static int HDFOffset;
    static String HDFRootGroupName;
    static String HDFDataVariableName;
    static String[] HDFDataVariableList;
    static String urlPrefix;

    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("EarthdataMapperRunnableExample").setMaster("local[2]");
        conf.set("spark.serializer", KryoSerializer.class.getName());
        conf.set("spark.kryo.registrator", SedonaKryoRegistrator.class.getName());
        sc = new JavaSparkContext(conf);
        Logger.getLogger((String)"org").setLevel(Level.WARN);
        Logger.getLogger((String)"akka").setLevel(Level.WARN);
        InputLocation = System.getProperty("user.dir") + "/src/test/resources/modis/modis.csv";
        splitter = FileDataSplitter.CSV;
        indexType = IndexType.RTREE;
        queryEnvelope = new Envelope(-90.01, -80.01, 30.01, 40.01);
        numPartitions = 5;
        loopTimes = 1;
        HDFIncrement = 5;
        HDFOffset = 2;
        HDFRootGroupName = "MOD_Swath_LST";
        HDFDataVariableName = "LST";
        urlPrefix = System.getProperty("user.dir") + "/src/test/resources/modis/";
        EarthdataMapperRunnableExample.testSpatialRangeQuery();
        EarthdataMapperRunnableExample.testSpatialRangeQueryUsingIndex();
        sc.stop();
        System.out.println("All Earthdata DEMOs passed!");
    }

    public static void testSpatialRangeQuery() {
        EarthdataHDFPointMapper earthdataHDFPoint = new EarthdataHDFPointMapper(HDFIncrement, HDFOffset, HDFRootGroupName, HDFDataVariableList, HDFDataVariableName, urlPrefix);
        PointRDD spatialRDD = new PointRDD(sc, InputLocation, numPartitions, earthdataHDFPoint);
        spatialRDD.rawSpatialRDD.persist(StorageLevel.MEMORY_ONLY());
        for (int i = 0; i < loopTimes; ++i) {
            try {
                long resultSize = RangeQuery.SpatialRangeQuery(spatialRDD, queryEnvelope, false, false).count();
                if ($assertionsDisabled || resultSize > 0L) continue;
                throw new AssertionError();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void testSpatialRangeQueryUsingIndex() {
        EarthdataHDFPointMapper earthdataHDFPoint = new EarthdataHDFPointMapper(HDFIncrement, HDFOffset, HDFRootGroupName, HDFDataVariableList, HDFDataVariableName, urlPrefix);
        PointRDD spatialRDD = new PointRDD(sc, InputLocation, numPartitions, earthdataHDFPoint);
        try {
            spatialRDD.buildIndex(IndexType.RTREE, false);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        spatialRDD.indexedRawRDD.persist(StorageLevel.MEMORY_ONLY());
        for (int i = 0; i < loopTimes; ++i) {
            try {
                long resultSize = RangeQuery.SpatialRangeQuery(spatialRDD, queryEnvelope, false, true).count();
                if ($assertionsDisabled || resultSize > 0L) continue;
                throw new AssertionError();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        HDFIncrement = 5;
        HDFOffset = 2;
        HDFRootGroupName = "MOD_Swath_LST";
        HDFDataVariableName = "LST";
        HDFDataVariableList = new String[]{"LST", "QC", "Error_LST", "Emis_31", "Emis_32"};
        urlPrefix = "";
    }
}

