/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster;

import java.awt.image.Raster;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.DoublePredicate;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.DirectPosition2D;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.TransformException;

public class PixelFunctions {
    public static Double value(GridCoverage2D rasterGeom, Geometry geometry, int band) throws TransformException {
        return PixelFunctions.values(rasterGeom, Collections.singletonList(geometry), band).get(0);
    }

    public static List<Double> values(GridCoverage2D rasterGeom, List<Geometry> geometries, int band) throws TransformException {
        int numBands = rasterGeom.getNumSampleDimensions();
        if (band < 1 || band > numBands) {
            return geometries.stream().map(geom -> null).collect(Collectors.toList());
        }
        Raster raster = rasterGeom.getRenderedImage().getData();
        GridGeometry2D gridGeometry = rasterGeom.getGridGeometry();
        double[] noDataValues = rasterGeom.getSampleDimension(band - 1).getNoDataValues();
        DoublePredicate isNoData = d -> noDataValues != null && DoubleStream.of(noDataValues).anyMatch(noDataValue -> Double.compare(noDataValue, d) == 0);
        double[] pixelBuffer = new double[numBands];
        ArrayList<Double> result = new ArrayList<Double>(geometries.size());
        for (Geometry geom2 : geometries) {
            if (geom2 == null) {
                result.add(null);
                continue;
            }
            Point point = PixelFunctions.ensurePoint(geom2);
            DirectPosition2D directPosition2D = new DirectPosition2D(point.getX(), point.getY());
            GridCoordinates2D gridCoordinates2D = gridGeometry.worldToGrid((DirectPosition)directPosition2D);
            try {
                double pixel = raster.getPixel(gridCoordinates2D.x, gridCoordinates2D.y, pixelBuffer)[band - 1];
                if (isNoData.test(pixel)) {
                    result.add(null);
                    continue;
                }
                result.add(pixel);
            }
            catch (ArrayIndexOutOfBoundsException exc) {
                result.add(null);
            }
        }
        return result;
    }

    private static Point ensurePoint(Geometry geometry) {
        if (geometry instanceof Point) {
            return (Point)geometry;
        }
        throw new IllegalArgumentException("Attempting to get the value of a pixel with a non-point geometry.");
    }
}

