/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.expressions.subdivide;

import java.io.Serializable;
import org.apache.spark.sql.sedona_sql.expressions.implicits$;
import org.apache.spark.sql.sedona_sql.expressions.simplify.GeometrySimplifier$;
import org.apache.spark.sql.sedona_sql.expressions.subdivide.GeometrySubDividerConfiguration$;
import org.apache.spark.sql.sedona_sql.expressions.subdivide.PivotFinder$;
import org.apache.spark.sql.sedona_sql.expressions.subdivide.SubBoxes;
import org.apache.spark.sql.sedona_sql.expressions.subdivide.SubdivideExtent;
import org.apache.spark.sql.sedona_sql.expressions.subdivide.SubdivideExtent$;
import org.geotools.geometry.jts.JTS;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class GeometrySubDivider$ {
    public static GeometrySubDivider$ MODULE$;
    private final GeometryFactory geometryFactory;

    static {
        new GeometrySubDivider$();
    }

    public GeometryFactory geometryFactory() {
        return this.geometryFactory;
    }

    public boolean equalValue(double value, double pivot) {
        return package$.MODULE$.abs(value - pivot) > GeometrySubDividerConfiguration$.MODULE$.FP_TOLERANCE();
    }

    public Seq<Geometry> subDivideRecursive(Geometry geom, int dimension, int maxVertices, int depth, Seq<Geometry> geometries) {
        Seq<Object> seq;
        block13: {
            while (true) {
                Envelope geometryBboxAligned;
                int numberOfVertices = geom.getNumPoints();
                Envelope geometryBbox = geom.getEnvelope().getEnvelopeInternal();
                double width = geometryBbox.getWidth();
                double height = geometryBbox.getHeight();
                Envelope envelope = width == 0.0 ? new Envelope(geometryBbox.getMinX() - GeometrySubDividerConfiguration$.MODULE$.FP_TOLERANCE(), geometryBbox.getMaxX() + GeometrySubDividerConfiguration$.MODULE$.FP_TOLERANCE(), geometryBbox.getMinY(), geometryBbox.getMaxY()) : (geometryBboxAligned = height == 0.0 ? new Envelope(geometryBbox.getMinX(), geometryBbox.getMaxX(), geometryBbox.getMinY() - GeometrySubDividerConfiguration$.MODULE$.FP_TOLERANCE(), geometryBbox.getMaxY() + GeometrySubDividerConfiguration$.MODULE$.FP_TOLERANCE()) : geometryBbox);
                if (geom == null || geom.getDimension() < dimension || numberOfVertices == 0 || geometryBboxAligned == null) {
                    seq = geometries;
                    break block13;
                }
                if (width == 0.0 && height == 0.0) {
                    Seq<Geometry> seq2;
                    Geometry geometry = geom;
                    if (geometry instanceof Point) {
                        Seq<Object> seq3;
                        if (dimension == 0) {
                            Geometry geometry2 = geom;
                            seq3 = geometries.$plus$colon(geometry2, Seq$.MODULE$.canBuildFrom());
                        } else {
                            seq3 = geometries;
                        }
                        seq2 = seq3;
                    } else if (geometry != null) {
                        seq2 = geometries;
                    } else {
                        throw new MatchError(geometry);
                    }
                    seq = seq2;
                    break block13;
                }
                if (geom instanceof GeometryCollection && !geom.getGeometryType().contains("Point")) {
                    GeometryCollection collection = (GeometryCollection)geom;
                    int numberOfGeometries = collection.getNumGeometries();
                    seq = (Seq)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numberOfGeometries).map((Function1<Object, Seq> & Serializable & scala.Serializable)i -> GeometrySubDivider$.MODULE$.subDivideRecursive(collection.getGeometryN(BoxesRunTime.unboxToInt(i)), dimension, maxVertices, depth, geometries), IndexedSeq$.MODULE$.canBuildFrom())).reduce((Function2<Seq, Seq, Seq> & Serializable & scala.Serializable)(x$2, x$3) -> x$2.$plus$plus(x$3, Seq$.MODULE$.canBuildFrom()));
                    break block13;
                }
                if (numberOfVertices <= maxVertices || depth > GeometrySubDividerConfiguration$.MODULE$.maxDepth()) {
                    Geometry geometry = geom;
                    seq = geometries.$plus$colon(geometry, Seq$.MODULE$.canBuildFrom());
                    break block13;
                }
                int split_ordinate = width > height ? 0 : 1;
                double center = split_ordinate == 0 ? (geometryBboxAligned.getMinX() + geometryBboxAligned.getMaxX()) / (double)2 : (geometryBboxAligned.getMinY() + geometryBboxAligned.getMaxY()) / (double)2;
                double pivot = PivotFinder$.MODULE$.findPivot(geom, split_ordinate, center, numberOfVertices);
                SubBoxes subBoxes = this.getSubBoxes(split_ordinate, SubdivideExtent$.MODULE$.fromClip(geometryBboxAligned), pivot, center);
                Geometry intersectedSimplified = this.getIntersectionGeometries(subBoxes.subBox(), geom);
                Geometry intersectedIter2Simplfied = this.getIntersectionGeometries(subBoxes.subBox2(), geom);
                if (implicits$.MODULE$.GeometryEnhancer(intersectedSimplified).isNonEmpty() && implicits$.MODULE$.GeometryEnhancer(intersectedIter2Simplfied).isNonEmpty()) {
                    seq = this.subDivideRecursive(intersectedSimplified, dimension, maxVertices, depth + 1, geometries).$plus$plus(this.subDivideRecursive(intersectedIter2Simplfied, dimension, maxVertices, depth + 1, geometries), Seq$.MODULE$.canBuildFrom());
                    break block13;
                }
                if (implicits$.MODULE$.GeometryEnhancer(intersectedSimplified).isNonEmpty()) {
                    ++depth;
                    geom = intersectedSimplified;
                    continue;
                }
                if (!implicits$.MODULE$.GeometryEnhancer(intersectedIter2Simplfied).isNonEmpty()) break;
                ++depth;
                geom = intersectedIter2Simplfied;
            }
            seq = geometries;
        }
        return seq;
    }

    private SubBoxes getSubBoxes(int split_ordinate, SubdivideExtent subbox, double pivot, double center) {
        SubBoxes subBoxes;
        if (split_ordinate == 0) {
            if (this.equalValue(subbox.xmax(), pivot) && this.equalValue(subbox.xmin(), pivot)) {
                double x$1 = pivot;
                double x$2 = subbox.copy$default$1();
                double x$3 = subbox.copy$default$3();
                double x$4 = subbox.copy$default$4();
                SubBoxes subBoxes2 = new SubBoxes(subbox.copy(x$2, x$1, x$3, x$4), subbox.copy(pivot, subbox.copy$default$2(), subbox.copy$default$3(), subbox.copy$default$4()));
                subBoxes = subBoxes2;
            } else {
                double x$5 = center;
                double x$6 = subbox.copy$default$1();
                double x$7 = subbox.copy$default$3();
                double x$8 = subbox.copy$default$4();
                SubBoxes subBoxes3 = new SubBoxes(subbox.copy(x$6, x$5, x$7, x$8), subbox.copy(center, subbox.copy$default$2(), subbox.copy$default$3(), subbox.copy$default$4()));
                subBoxes = subBoxes3;
            }
        } else if (this.equalValue(subbox.ymax(), pivot) && this.equalValue(subbox.ymin(), pivot)) {
            double x$9 = pivot;
            double x$10 = subbox.copy$default$1();
            double x$11 = subbox.copy$default$2();
            double x$12 = subbox.copy$default$3();
            double x$13 = pivot;
            double x$14 = subbox.copy$default$1();
            double x$15 = subbox.copy$default$2();
            double x$16 = subbox.copy$default$4();
            SubBoxes subBoxes4 = new SubBoxes(subbox.copy(x$10, x$11, x$12, x$9), subbox.copy(x$14, x$15, x$13, x$16));
            subBoxes = subBoxes4;
        } else {
            double x$17 = center;
            double x$18 = subbox.copy$default$1();
            double x$19 = subbox.copy$default$2();
            double x$20 = subbox.copy$default$3();
            double x$21 = center;
            double x$22 = subbox.copy$default$1();
            double x$23 = subbox.copy$default$2();
            double x$24 = subbox.copy$default$4();
            SubBoxes subBoxes5 = new SubBoxes(subbox.copy(x$18, x$19, x$20, x$17), subbox.copy(x$22, x$23, x$21, x$24));
            subBoxes = subBoxes5;
        }
        return subBoxes;
    }

    private Geometry getIntersectionGeometries(SubdivideExtent extent, Geometry geom) {
        Envelope subBox = new Envelope(extent.xmin(), extent.xmax(), extent.ymin(), extent.ymax());
        Geometry intersected = geom.intersection((Geometry)JTS.toGeometry((Envelope)subBox));
        return GeometrySimplifier$.MODULE$.simplify(intersected, true, 0.0);
    }

    public Seq<Geometry> subDividePrecise(Geometry geom, int maxVertices) {
        return geom == null ? (Seq<Geometry>)Nil$.MODULE$ : (maxVertices < GeometrySubDividerConfiguration$.MODULE$.minMaxVertices() ? (Seq)Nil$.MODULE$ : this.subDivideRecursive(geom, geom.getDimension(), maxVertices, GeometrySubDividerConfiguration$.MODULE$.startDepth(), Nil$.MODULE$));
    }

    public Seq<Geometry> subDivide(Geometry geom, int maxVertices) {
        return this.subDividePrecise(geom, maxVertices);
    }

    private GeometrySubDivider$() {
        MODULE$ = this;
        this.geometryFactory = new GeometryFactory();
    }
}

