/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.strategy.join;

import java.io.Serializable;
import org.apache.sedona.core.spatialRDD.SpatialRDD;
import org.apache.sedona.core.utils.SedonaConf;
import org.apache.sedona.sql.utils.GeometrySerializer$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005=b!C\u0004\t!\u0003\r\taFA\r\u0011\u0015q\u0002\u0001\"\u0001 \u0011\u0015\u0019\u0003\u0001\"\u0001%\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u0015)\u0007\u0001\"\u0001g\u0011\u0015i\b\u0001\"\u0003\u007f\u0005I!&/Y5u\u0015>Lg.U;fef\u0014\u0015m]3\u000b\u0005%Q\u0011\u0001\u00026pS:T!a\u0003\u0007\u0002\u0011M$(/\u0019;fOfT!!\u0004\b\u0002\u0015M,Gm\u001c8b?N\fHN\u0003\u0002\u0010!\u0005\u00191/\u001d7\u000b\u0005E\u0011\u0012!B:qCJ\\'BA\n\u0015\u0003\u0019\t\u0007/Y2iK*\tQ#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00011A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\fa\u0001J5oSR$C#\u0001\u0011\u0011\u0005e\t\u0013B\u0001\u0012\u001b\u0005\u0011)f.\u001b;\u0002!Q|7\u000b]1uS\u0006d'\u000b\u001a3QC&\u0014H#B\u0013=\u0019F\u001b\u0006\u0003B\r'Q!J!a\n\u000e\u0003\rQ+\b\u000f\\33!\rI\u0003GM\u0007\u0002U)\u00111\u0006L\u0001\u000bgB\fG/[1m%\u0012#%BA\u0017/\u0003\u0011\u0019wN]3\u000b\u0005=\u0012\u0012AB:fI>t\u0017-\u0003\u00022U\tQ1\u000b]1uS\u0006d'\u000b\u0012#\u0011\u0005MRT\"\u0001\u001b\u000b\u0005U2\u0014\u0001B4f_6T!a\u000e\u001d\u0002\u0007)$8O\u0003\u0002:)\u0005aAn\\2bi&|g\u000e^3dQ&\u00111\b\u000e\u0002\t\u000f\u0016|W.\u001a;ss\")QH\u0001a\u0001}\u00059A.\u001a4u%\u0012$\u0007cA C\t6\t\u0001I\u0003\u0002B!\u0005\u0019!\u000f\u001a3\n\u0005\r\u0003%a\u0001*E\tB\u0011QIS\u0007\u0002\r*\u0011q\tS\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002J\u001d\u0005A1-\u0019;bYf\u001cH/\u0003\u0002L\r\nIQK\\:bM\u0016\u0014vn\u001e\u0005\u0006\u001b\n\u0001\rAT\u0001\u000eY\u00164Go\u00155ba\u0016,\u0005\u0010\u001d:\u0011\u0005\u0015{\u0015B\u0001)G\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0006%\n\u0001\rAP\u0001\te&<\u0007\u000e\u001e*eI\")AK\u0001a\u0001\u001d\u0006q!/[4iiNC\u0017\r]3FqB\u0014\u0018\u0001\u0004;p'B\fG/[1m%\u0012#Ec\u0001\u0015X1\")\u0011i\u0001a\u0001}!)\u0011l\u0001a\u0001\u001d\u0006y1\u000f[1qK\u0016C\bO]3tg&|g.A\u000bu_\u0016C\b/\u00198eK\u0012,eN^3m_B,'\u000b\u0012#\u0015\u000b!bVL\u00181\t\u000b\u0005#\u0001\u0019\u0001 \t\u000be#\u0001\u0019\u0001(\t\u000b}#\u0001\u0019\u0001(\u0002\u0017\t|WO\u001c3SC\u0012LWo\u001d\u0005\u0006C\u0012\u0001\rAY\u0001\fSN<Um\\4sCBD\u0017\u0010\u0005\u0002\u001aG&\u0011AM\u0007\u0002\b\u0005>|G.Z1o\u0003U!wn\u00159bi&\fG\u000eU1si&$\u0018n\u001c8j]\u001e$R\u0001I4jWVDQ\u0001[\u0003A\u0002!\na\u0002Z8nS:\fg\u000e^*iCB,7\u000fC\u0003k\u000b\u0001\u0007\u0001&\u0001\bg_2dwn^3s'\"\f\u0007/Z:\t\u000b1,\u0001\u0019A7\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t!\tq7/D\u0001p\u0015\t\u0001\u0018/\u0001\u0003mC:<'\"\u0001:\u0002\t)\fg/Y\u0005\u0003i>\u0014q!\u00138uK\u001e,'\u000fC\u0003w\u000b\u0001\u0007q/\u0001\u0006tK\u0012|g.Y\"p]\u001a\u0004\"\u0001_>\u000e\u0003eT!A\u001f\u0017\u0002\u000bU$\u0018\u000e\\:\n\u0005qL(AC*fI>t\u0017mQ8oM\u0006qQ\r\u001f9b]\u0012,eN^3m_B,G\u0003\u0003\u0011\u0000\u0003\u0013\t\u0019\"a\u0006\t\u000f\u0005\u0005a\u00011\u0001\u0002\u0004\u0005AQM\u001c<fY>\u0004X\rE\u00024\u0003\u000bI1!a\u00025\u0005!)eN^3m_B,\u0007bBA\u0006\r\u0001\u0007\u0011QB\u0001\tI&\u001cH/\u00198dKB\u0019\u0011$a\u0004\n\u0007\u0005E!D\u0001\u0004E_V\u0014G.\u001a\u0005\b\u0003+1\u0001\u0019AA\u0007\u0003\u0019\u0011\u0018\rZ5vg\")\u0011M\u0002a\u0001EJ1\u00111DA\u0010\u0003G1a!!\b\u0001\u0001\u0005e!\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004cAA\u0011\u00015\t\u0001\u0002\u0005\u0003\u0002&\u0005-RBAA\u0014\u0015\r\tICD\u0001\nKb,7-\u001e;j_:LA!!\f\u0002(\tI1\u000b]1sWBc\u0017M\u001c")
public interface TraitJoinQueryBase {
    public static /* synthetic */ Tuple2 toSpatialRddPair$(TraitJoinQueryBase $this, RDD leftRdd, Expression leftShapeExpr, RDD rightRdd, Expression rightShapeExpr) {
        return $this.toSpatialRddPair((RDD<UnsafeRow>)leftRdd, leftShapeExpr, (RDD<UnsafeRow>)rightRdd, rightShapeExpr);
    }

    default public Tuple2<SpatialRDD<Geometry>, SpatialRDD<Geometry>> toSpatialRddPair(RDD<UnsafeRow> leftRdd, Expression leftShapeExpr, RDD<UnsafeRow> rightRdd, Expression rightShapeExpr) {
        return new Tuple2(this.toSpatialRDD(leftRdd, leftShapeExpr), this.toSpatialRDD(rightRdd, rightShapeExpr));
    }

    public static /* synthetic */ SpatialRDD toSpatialRDD$(TraitJoinQueryBase $this, RDD rdd, Expression shapeExpression) {
        return $this.toSpatialRDD((RDD<UnsafeRow>)rdd, shapeExpression);
    }

    /*
     * WARNING - void declaration
     */
    default public SpatialRDD<Geometry> toSpatialRDD(RDD<UnsafeRow> rdd, Expression shapeExpression) {
        void var3_3;
        SpatialRDD spatialRdd = new SpatialRDD();
        spatialRdd.setRawSpatialRDD(rdd.map((Function1 & Serializable)x -> {
            void var2_2;
            Geometry shape = GeometrySerializer$.MODULE$.deserialize((byte[])shapeExpression.eval((InternalRow)x));
            shape.setUserData((Object)x.copy());
            return var2_2;
        }, ClassTag$.MODULE$.apply(Geometry.class)).toJavaRDD());
        return var3_3;
    }

    public static /* synthetic */ SpatialRDD toExpandedEnvelopeRDD$(TraitJoinQueryBase $this, RDD rdd, Expression shapeExpression, Expression boundRadius, boolean isGeography) {
        return $this.toExpandedEnvelopeRDD((RDD<UnsafeRow>)rdd, shapeExpression, boundRadius, isGeography);
    }

    default public SpatialRDD<Geometry> toExpandedEnvelopeRDD(RDD<UnsafeRow> rdd, Expression shapeExpression, Expression boundRadius, boolean isGeography) {
        SpatialRDD spatialRdd = new SpatialRDD();
        spatialRdd.setRawSpatialRDD(rdd.map((Function1 & Serializable)x -> {
            Geometry shape = GeometrySerializer$.MODULE$.deserialize((byte[])shapeExpression.eval((InternalRow)x));
            Envelope envelope = shape.getEnvelopeInternal().copy();
            this.expandEnvelope(envelope, BoxesRunTime.unboxToDouble((Object)boundRadius.eval((InternalRow)x)), 6357000.0, isGeography);
            Geometry expandedEnvelope = shape.getFactory().toGeometry(envelope);
            expandedEnvelope.setUserData((Object)x.copy());
            return expandedEnvelope;
        }, ClassTag$.MODULE$.apply(Geometry.class)).toJavaRDD());
        return spatialRdd;
    }

    public static /* synthetic */ void doSpatialPartitioning$(TraitJoinQueryBase $this, SpatialRDD dominantShapes, SpatialRDD followerShapes, Integer numPartitions, SedonaConf sedonaConf) {
        $this.doSpatialPartitioning((SpatialRDD<Geometry>)dominantShapes, (SpatialRDD<Geometry>)followerShapes, numPartitions, sedonaConf);
    }

    default public void doSpatialPartitioning(SpatialRDD<Geometry> dominantShapes, SpatialRDD<Geometry> followerShapes, Integer numPartitions, SedonaConf sedonaConf) {
        block0: {
            if (dominantShapes.approximateTotalCount <= 0L) break block0;
            dominantShapes.spatialPartitioning(sedonaConf.getJoinGridType(), Predef$.MODULE$.Integer2int(numPartitions));
            followerShapes.spatialPartitioning(dominantShapes.getPartitioner());
        }
    }

    private void expandEnvelope(Envelope envelope, double distance, double radius, boolean isGeography) {
        if (isGeography) {
            double scaleFactor = 1.1;
            double latRadian = Math.toRadians((envelope.getMinX() + envelope.getMaxX()) / 2.0);
            double latDeltaRadian = distance / radius;
            double latDeltaDegree = Math.toDegrees(latDeltaRadian);
            double lonDeltaRadian = Math.max(Math.abs(distance / (radius * Math.cos(latRadian + latDeltaRadian))), Math.abs(distance / (radius * Math.cos(latRadian - latDeltaRadian))));
            double lonDeltaDegree = Math.toDegrees(lonDeltaRadian);
            envelope.expandBy(latDeltaDegree * scaleFactor, lonDeltaDegree * scaleFactor);
        } else {
            envelope.expandBy(distance);
        }
    }

    public static void $init$(TraitJoinQueryBase $this) {
    }
}

