/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.codec.protobuf.codec;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.protobuf.schema.ProtobufField;
import com.fasterxml.jackson.dataformat.protobuf.schema.ProtobufSchema;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.servicecomb.codec.protobuf.codec.AbstractCodec;
import org.apache.servicecomb.codec.protobuf.jackson.CseObjectReader;

public class AbstractFieldCodec
extends AbstractCodec {
    protected Map<String, ReaderHelpData> readerHelpDataMap = new HashMap<String, ReaderHelpData>();

    @Override
    public void init(ProtobufSchema schema, Type ... types) {
        this.initFieldMap(schema, types);
    }

    private void initFieldMap(ProtobufSchema schema, Type[] types) {
        Iterator fieldIter = schema.getRootType().fields().iterator();
        for (int idx = 0; idx < schema.getRootType().getFieldCount(); ++idx) {
            JavaType type = TypeFactory.defaultInstance().constructType(types[idx]);
            ProtobufField field = (ProtobufField)fieldIter.next();
            ReaderHelpData helpData = new ReaderHelpData();
            helpData.index = idx;
            helpData.deser = ((CseObjectReader)this.reader).findDeserializer(type);
            this.readerHelpDataMap.put(field.name, helpData);
        }
    }

    public ReaderHelpData findInfo(String name) {
        return this.readerHelpDataMap.get(name);
    }

    public static class ReaderHelpData {
        private int index;
        private JsonDeserializer<Object> deser;

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public JsonDeserializer<Object> getDeser() {
            return this.deser;
        }

        public void setDeser(JsonDeserializer<Object> deser) {
            this.deser = deser;
        }
    }
}

