/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.codec.protobuf.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.Map;
import org.apache.servicecomb.codec.protobuf.codec.AbstractFieldCodec;

public abstract class AbstractDeserializer
extends JsonDeserializer<Object> {
    protected Map<String, AbstractFieldCodec.ReaderHelpData> readerHelpDataMap;

    public AbstractDeserializer(Map<String, AbstractFieldCodec.ReaderHelpData> readerHelpDataMap) {
        this.readerHelpDataMap = readerHelpDataMap;
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Object result = this.createResult();
        String fieldName = p.nextFieldName();
        while (fieldName != null) {
            AbstractFieldCodec.ReaderHelpData helpData = this.readerHelpDataMap.get(fieldName);
            if (helpData != null) {
                JsonToken t = p.nextToken();
                Object value = null;
                value = t == JsonToken.VALUE_NULL ? helpData.getDeser().getNullValue(ctxt) : helpData.getDeser().deserialize(p, ctxt);
                result = this.updateResult(result, value, helpData);
            }
            fieldName = p.nextFieldName();
        }
        return result;
    }

    protected abstract Object createResult();

    protected abstract Object updateResult(Object var1, Object var2, AbstractFieldCodec.ReaderHelpData var3);
}

