/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.param;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.netflix.config.DynamicPropertyFactory;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.common.rest.codec.RestClientRequest;
import org.apache.servicecomb.common.rest.codec.param.AbstractParamProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreator;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreatorManager;
import org.apache.servicecomb.swagger.converter.property.SwaggerParamCollectionFormat;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;

public class QueryProcessorCreator
implements ParamValueProcessorCreator {
    public static final String PARAMTYPE = "query";

    public QueryProcessorCreator() {
        ParamValueProcessorCreatorManager.INSTANCE.register(PARAMTYPE, this);
    }

    @Override
    public ParamValueProcessor create(Parameter parameter, Type genericParamType) {
        JavaType targetType = genericParamType == null ? null : TypeFactory.defaultInstance().constructType(genericParamType);
        return new QueryProcessor((QueryParameter)parameter, targetType);
    }

    public static class QueryProcessor
    extends AbstractParamProcessor {
        private boolean emptyAsNull = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.rest.parameter.query.emptyAsNull", false).get();
        private boolean ignoreDefaultValue = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.rest.parameter.query.ignoreDefaultValue", false).get();
        private boolean ignoreRequiredCheck = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.rest.parameter.query.ignoreRequiredCheck", false).get();
        private boolean repeatedType;
        private SwaggerParamCollectionFormat collectionFormat;

        public QueryProcessor(QueryParameter queryParameter, JavaType targetType) {
            super(queryParameter.getName(), targetType, queryParameter.getDefaultValue(), queryParameter.getRequired());
            this.repeatedType = ArrayProperty.isType((String)queryParameter.getType());
            if (StringUtils.isNotEmpty((CharSequence)queryParameter.getCollectionFormat())) {
                this.collectionFormat = SwaggerParamCollectionFormat.valueOf((String)queryParameter.getCollectionFormat().toUpperCase());
            }
        }

        @Override
        public Object getValue(HttpServletRequest request) {
            if (this.repeatedType && SwaggerParamCollectionFormat.MULTI.equals((Object)this.collectionFormat)) {
                String[] value = request.getParameterValues(this.paramPath);
                return this.convertValue(value, this.targetType);
            }
            String[] value = request.getParameter(this.paramPath);
            if (this.emptyAsNull && StringUtils.isEmpty((CharSequence)value)) {
                value = null;
            }
            if (value == null) {
                value = this.checkRequiredAndDefaultValue();
            }
            if (null != this.collectionFormat) {
                value = this.collectionFormat.splitParam((String)value);
            }
            return this.convertValue(value, this.targetType);
        }

        private Object checkRequiredAndDefaultValue() {
            if (!this.ignoreRequiredCheck && this.isRequired()) {
                throw new InvocationException((Response.StatusType)Response.Status.BAD_REQUEST, "Parameter is required.");
            }
            Object defaultValue = this.getDefaultValue();
            if (!this.ignoreDefaultValue && defaultValue != null) {
                return defaultValue;
            }
            return null;
        }

        @Override
        public void setValue(RestClientRequest clientRequest, Object arg) throws Exception {
        }

        @Override
        public String getProcessorType() {
            return QueryProcessorCreator.PARAMTYPE;
        }

        public SwaggerParamCollectionFormat getCollectionFormat() {
            return this.collectionFormat;
        }
    }
}

