/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.utils;

import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.foundation.common.utils.JvmUtils;
import org.springframework.aop.TargetClassAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class BeanUtils {
    public static final String DEFAULT_BEAN_RESOURCE = "classpath*:META-INF/spring/*.bean.xml";
    public static final String SCB_SCAN_PACKAGE = "scb-scan-package";
    private static final String SCB_PACKAGE = "org.apache.servicecomb";
    private static ApplicationContext context;

    private BeanUtils() {
    }

    public static void init() {
        BeanUtils.init(DEFAULT_BEAN_RESOURCE);
    }

    public static void init(String ... configLocations) {
        BeanUtils.prepareServiceCombScanPackage();
        context = new ClassPathXmlApplicationContext(configLocations);
    }

    public static void prepareServiceCombScanPackage() {
        String pkg;
        LinkedHashSet<String> scanPackags = new LinkedHashSet<String>();
        String exists = System.getProperty(SCB_SCAN_PACKAGE);
        if (exists != null) {
            for (String exist : exists.trim().split(",")) {
                if (exist.isEmpty()) continue;
                scanPackags.add(exist.trim());
            }
        }
        scanPackags.add(SCB_PACKAGE);
        Class<?> mainClass = JvmUtils.findMainClass();
        if (mainClass != null && !(pkg = mainClass.getPackage().getName()).startsWith(SCB_PACKAGE)) {
            scanPackags.add(pkg);
        }
        System.setProperty(SCB_SCAN_PACKAGE, StringUtils.join(scanPackags, (String)","));
    }

    public static ApplicationContext getContext() {
        return context;
    }

    public static void setContext(ApplicationContext applicationContext) {
        context = applicationContext;
    }

    public static <T> T getBean(String name) {
        return (T)context.getBean(name);
    }

    public static Class<?> getImplClassFromBean(Object bean) {
        if (TargetClassAware.class.isInstance(bean)) {
            return ((TargetClassAware)bean).getTargetClass();
        }
        return bean.getClass();
    }
}

