/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JvmUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JvmUtils.class);
    @VisibleForTesting
    static final String SUN_JAVA_COMMAND = "sun.java.command";

    private JvmUtils() {
    }

    public static Class<?> findMainClass() {
        String command = System.getProperty(SUN_JAVA_COMMAND);
        if (command == null || command.isEmpty()) {
            return null;
        }
        String mainClassOrJar = command.trim().split(" ")[0];
        String mainClass = JvmUtils.readFromJar(mainClassOrJar);
        if (mainClass == null || mainClass.isEmpty()) {
            return null;
        }
        try {
            Class<?> cls = Class.forName(mainClass);
            LOGGER.info("Found main class \"{}\".", (Object)mainClass);
            return cls;
        }
        catch (Throwable e) {
            LOGGER.warn("\"{}\" is not a valid class.", (Object)mainClass, (Object)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readFromJar(String mainClassOrJar) {
        if (!mainClassOrJar.endsWith(".jar")) {
            return mainClassOrJar;
        }
        String manifestUri = "jar:file:" + new File(mainClassOrJar).getAbsolutePath() + "!/" + "META-INF/MANIFEST.MF";
        try {
            URL url = new URL(manifestUri);
            try (InputStream inputStream = url.openStream();){
                Manifest manifest = new Manifest(inputStream);
                String string = manifest.getMainAttributes().getValue("Main-Class");
                return string;
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to read Main-Class from \"{}\".", (Object)manifestUri, (Object)e);
            return null;
        }
    }

    public static ClassLoader correctClassLoader(ClassLoader classLoader) {
        ClassLoader targetClassLoader = classLoader;
        if (targetClassLoader == null) {
            targetClassLoader = Thread.currentThread().getContextClassLoader();
        }
        if (targetClassLoader == null) {
            targetClassLoader = JvmUtils.class.getClassLoader();
        }
        return targetClassLoader;
    }

    public static ClassLoader findClassLoader() {
        return JvmUtils.correctClassLoader(null);
    }
}

