/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.archaius.sources;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.config.archaius.sources.ConfigModel;
import org.springframework.util.ResourceUtils;

public abstract class AbstractConfigLoader {
    protected String orderKey = "config-order";
    protected final List<ConfigModel> configModels = new ArrayList<ConfigModel>();

    public void setOrderKey(String orderKey) {
        this.orderKey = orderKey;
    }

    public List<ConfigModel> getConfigModels() {
        return this.configModels;
    }

    public void load(String resourceName) throws IOException {
        this.loadFromClassPath(resourceName);
    }

    protected void loadFromClassPath(String resourceName) throws IOException {
        List<URL> urlList = this.findURLFromClassPath(resourceName);
        for (URL url : urlList) {
            ConfigModel configModel = this.load(url);
            this.configModels.add(configModel);
        }
    }

    public ConfigModel load(URL url) throws IOException {
        Map<String, Object> config = this.loadData(url);
        if (config == null) {
            config = new LinkedHashMap<String, Object>();
        }
        ConfigModel configModel = new ConfigModel();
        configModel.setUrl(url);
        configModel.setConfig(config);
        Object objOrder = config.get(this.orderKey);
        if (objOrder != null) {
            if (Integer.class.isInstance(objOrder)) {
                configModel.setOrder((Integer)objOrder);
            } else {
                configModel.setOrder(Integer.parseInt(String.valueOf(objOrder)));
            }
        }
        return configModel;
    }

    protected abstract Map<String, Object> loadData(URL var1) throws IOException;

    protected List<URL> findURLFromClassPath(String resourceName) throws IOException {
        ArrayList<URL> urlList = new ArrayList<URL>();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> urls = loader.getResources(resourceName);
        while (urls.hasMoreElements()) {
            urlList.add(urls.nextElement());
        }
        return urlList;
    }

    protected void sort() {
        ArrayList<ConfigModelWrapper> list = new ArrayList<ConfigModelWrapper>(this.configModels.size());
        int idx = 0;
        while (idx < this.configModels.size()) {
            ConfigModelWrapper wrapper = new ConfigModelWrapper();
            wrapper.model = this.configModels.get(idx);
            wrapper.addOrder = idx++;
            list.add(wrapper);
        }
        list.sort(this::doSort);
        for (idx = 0; idx < this.configModels.size(); ++idx) {
            this.configModels.set(idx, ((ConfigModelWrapper)list.get((int)idx)).model);
        }
    }

    private int doSort(ConfigModelWrapper w1, ConfigModelWrapper w2) {
        boolean isM2Jar;
        ConfigModel m1 = w1.model;
        ConfigModel m2 = w2.model;
        boolean isM1Jar = ResourceUtils.isJarURL((URL)m1.getUrl());
        if (isM1Jar != (isM2Jar = ResourceUtils.isJarURL((URL)m2.getUrl()))) {
            if (isM1Jar) {
                return -1;
            }
            return 1;
        }
        int result = Integer.compare(m1.getOrder(), m2.getOrder());
        if (result != 0) {
            return result;
        }
        return this.doFinalSort(w1, w2);
    }

    private int doFinalSort(ConfigModelWrapper w1, ConfigModelWrapper w2) {
        return Integer.compare(w1.addOrder, w2.addOrder);
    }

    private class ConfigModelWrapper {
        ConfigModel model;
        int addOrder;

        private ConfigModelWrapper() {
        }
    }
}

