/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public final class KeyStoreUtil {
    private KeyStoreUtil() {
    }

    public static KeyStore createKeyStore(String storeName, String storeType, char[] storeValue) {
        if (storeName == null) {
            return null;
        }
        File storeFile = new File(storeName);
        try {
            if (storeFile.isFile()) {
                return KeyStoreUtil.createKeyStore(new FileInputStream(storeFile), storeType, storeValue);
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader() == null ? KeyStoreUtil.class.getClassLoader() : Thread.currentThread().getContextClassLoader();
            URL resource = classLoader.getResource(storeName);
            if (resource != null) {
                return KeyStoreUtil.createKeyStore(resource.openStream(), storeType, storeValue);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Bad key store or value." + e.getMessage());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyStore createKeyStore(InputStream store, String storeType, char[] storeValue) {
        try (InputStream is = store;){
            KeyStore keystore = KeyStore.getInstance(storeType);
            keystore.load(is, storeValue);
            KeyStore keyStore = keystore;
            return keyStore;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Bad key store or value." + e.getMessage());
        }
    }

    public static CRL[] createCRL(String crlfile) {
        InputStream is = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            is = new FileInputStream(crlfile);
            Collection<? extends CRL> c = cf.generateCRLs(is);
            CRL[] cRLArray = c.toArray(new CRL[c.size()]);
            return cRLArray;
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException("bad cert file.");
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("crl file not found.");
        }
        catch (CRLException e) {
            throw new IllegalArgumentException("bad crl file.");
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    KeyStoreUtil.ignore();
                }
            }
        }
    }

    public static KeyManager[] createKeyManagers(KeyStore keystore, char[] keyvalue) {
        try {
            KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmfactory.init(keystore, keyvalue);
            return kmfactory.getKeyManagers();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Bad key store." + e.getMessage());
        }
    }

    public static TrustManager[] createTrustManagers(KeyStore keystore) {
        try {
            TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmfactory.init(keystore);
            return tmfactory.getTrustManagers();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Bad trust store." + e.getMessage());
        }
    }

    private static void ignore() {
    }
}

