/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.ssl;

import java.io.IOException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.commons.lang.StringUtils;
import org.apache.servicecomb.foundation.ssl.KeyStoreUtil;
import org.apache.servicecomb.foundation.ssl.SSLCustom;
import org.apache.servicecomb.foundation.ssl.SSLOption;
import org.apache.servicecomb.foundation.ssl.SSLSocketFactoryExt;
import org.apache.servicecomb.foundation.ssl.TrustAllManager;
import org.apache.servicecomb.foundation.ssl.TrustManagerExt;

public final class SSLManager {
    private SSLManager() {
    }

    public static SSLContext createSSLContext(SSLOption option, SSLCustom custom) {
        try {
            String keyStoreName = custom.getFullPath(option.getKeyStore());
            char[] keyStoreValue = option.getKeyStoreValue() == null ? new char[]{} : custom.decode(option.getKeyStoreValue().toCharArray());
            KeyStore keyStore = KeyStoreUtil.createKeyStore(keyStoreName, option.getKeyStoreType(), keyStoreValue);
            KeyManager[] keyManager = null;
            if (keyStore != null) {
                keyManager = KeyStoreUtil.createKeyManagers(keyStore, keyStoreValue);
            }
            String trustStoreName = custom.getFullPath(option.getTrustStore());
            char[] trustStoreValue = option.getTrustStoreValue() == null ? new char[]{} : custom.decode(option.getTrustStoreValue().toCharArray());
            KeyStore trustStore = KeyStoreUtil.createKeyStore(trustStoreName, option.getTrustStoreType(), trustStoreValue);
            TrustManager[] trustManager = trustStore != null ? KeyStoreUtil.createTrustManagers(trustStore) : new TrustManager[]{new TrustAllManager()};
            TrustManager[] wrapped = new TrustManager[trustManager.length];
            for (int i = 0; i < trustManager.length; ++i) {
                wrapped[i] = new TrustManagerExt((X509ExtendedTrustManager)trustManager[i], option, custom);
            }
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(keyManager, wrapped, new SecureRandom());
            return context;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("NoSuchAlgorithmException." + e.getMessage());
        }
        catch (KeyManagementException e) {
            throw new IllegalArgumentException("KeyManagementException." + e.getMessage());
        }
    }

    public static SSLSocketFactory createSSLSocketFactory(SSLOption option, SSLCustom custom) {
        SSLContext context = SSLManager.createSSLContext(option, custom);
        SSLSocketFactory factory = context.getSocketFactory();
        String[] supported = factory.getSupportedCipherSuites();
        String[] enabled = option.getCiphers().split(",");
        return new SSLSocketFactoryExt(factory, SSLManager.getEnabledCiphers(supported, enabled), option.getProtocols().split(","));
    }

    public static SSLEngine createSSLEngine(SSLOption option, SSLCustom custom) {
        SSLContext context = SSLManager.createSSLContext(option, custom);
        SSLEngine engine = context.createSSLEngine();
        engine.setEnabledProtocols(option.getProtocols().split(","));
        String[] supported = engine.getSupportedCipherSuites();
        String[] enabled = option.getCiphers().split(",");
        engine.setEnabledCipherSuites(SSLManager.getEnabledCiphers(supported, enabled));
        SSLManager.setClientAuth(option, engine);
        return engine;
    }

    public static SSLEngine createSSLEngine(SSLOption option, SSLCustom custom, String peerHost, int peerPort) {
        SSLContext context = SSLManager.createSSLContext(option, custom);
        SSLEngine engine = context.createSSLEngine(peerHost, peerPort);
        engine.setEnabledProtocols(option.getProtocols().split(","));
        String[] supported = engine.getSupportedCipherSuites();
        String[] enabled = option.getCiphers().split(",");
        engine.setEnabledCipherSuites(SSLManager.getEnabledCiphers(supported, enabled));
        SSLManager.setClientAuth(option, engine);
        return engine;
    }

    private static void setClientAuth(SSLOption option, SSLEngine engine) {
        if (option.isAuthPeer() || "REQUIRED".equals(option.getClientAuth())) {
            engine.setNeedClientAuth(true);
            return;
        }
        if ("NONE".equals(option.getClientAuth())) {
            engine.setNeedClientAuth(false);
            engine.setWantClientAuth(false);
            return;
        }
        engine.setWantClientAuth(true);
    }

    private static void setClientAuth(SSLOption option, SSLServerSocket serverSocket) {
        if (option.isAuthPeer() || "REQUIRED".equals(option.getClientAuth())) {
            serverSocket.setNeedClientAuth(true);
            return;
        }
        if ("NONE".equals(option.getClientAuth())) {
            serverSocket.setNeedClientAuth(false);
            serverSocket.setWantClientAuth(false);
            return;
        }
        serverSocket.setWantClientAuth(true);
    }

    public static SSLServerSocket createSSLServerSocket(SSLOption option, SSLCustom custom) {
        try {
            SSLContext context = SSLManager.createSSLContext(option, custom);
            SSLServerSocketFactory factory = context.getServerSocketFactory();
            SSLServerSocket socket = (SSLServerSocket)factory.createServerSocket();
            socket.setEnabledProtocols(option.getProtocols().split(","));
            String[] supported = socket.getSupportedCipherSuites();
            String[] enabled = option.getCiphers().split(",");
            socket.setEnabledCipherSuites(SSLManager.getEnabledCiphers(supported, enabled));
            SSLManager.setClientAuth(option, socket);
            return socket;
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("unkown host");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("unable create socket");
        }
    }

    public static SSLSocket createSSLSocket(SSLOption option, SSLCustom custom) {
        try {
            SSLContext context = SSLManager.createSSLContext(option, custom);
            SSLSocketFactory factory = context.getSocketFactory();
            SSLSocket socket = (SSLSocket)factory.createSocket();
            socket.setEnabledProtocols(option.getProtocols().split(","));
            String[] supported = socket.getSupportedCipherSuites();
            String[] enabled = option.getCiphers().split(",");
            socket.setEnabledCipherSuites(SSLManager.getEnabledCiphers(supported, enabled));
            return socket;
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("unknown host");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("unable create socket");
        }
    }

    private static String[] getEnabledCiphers(String[] supported, String[] enabled) {
        String[] result = new String[enabled.length];
        int count = 0;
        block0: for (String e : enabled) {
            for (String s : supported) {
                if (!e.equals(s)) continue;
                result[count++] = e;
                continue block0;
            }
        }
        if (count == 0) {
            throw new IllegalArgumentException("no enabled cipher suits.");
        }
        String[] r = new String[count];
        System.arraycopy(result, 0, r, 0, count);
        return r;
    }

    public static String[] getEnabledCiphers(SSLOption sslOption) {
        SSLOption option = new SSLOption();
        if (StringUtils.isNotEmpty((String)sslOption.getProtocols())) {
            option.setProtocols(sslOption.getProtocols());
        } else {
            option.setProtocols("TLSv1.2");
        }
        option.setCiphers(sslOption.getCiphers());
        SSLCustom custom = SSLCustom.defaultSSLCustom();
        SSLSocket socket = SSLManager.createSSLSocket(option, custom);
        return socket.getEnabledCipherSuites();
    }
}

