/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.test.scaffolding.spring;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.StringValueResolver;

public final class SpringUtils {
    private SpringUtils() {
    }

    public static StringValueResolver createStringValueResolver(Map<String, Object> map) {
        StandardEnvironment standardEnvironment = new StandardEnvironment();
        standardEnvironment.getPropertySources().addFirst((PropertySource)new MapPropertySource(UUID.randomUUID().toString(), map));
        return arg_0 -> ((StandardEnvironment)standardEnvironment).resolvePlaceholders(arg_0);
    }

    public static void ensureNoInject(Class<?> cls) {
        for (Field field : cls.getDeclaredFields()) {
            if (field.getAnnotation(Inject.class) != null) {
                throw new IllegalStateException(String.format("field %s:%s has %s annotation", cls.getName(), field.getName(), Inject.class.getName()));
            }
            if (field.getAnnotation(Autowired.class) == null) continue;
            throw new IllegalStateException(String.format("field %s:%s has %s annotation", cls.getName(), field.getName(), Autowired.class.getName()));
        }
        for (AccessibleObject accessibleObject : cls.getDeclaredMethods()) {
            if (((Method)accessibleObject).getAnnotation(Inject.class) != null) {
                throw new IllegalStateException(String.format("method %s:%s has %s annotation", cls.getName(), ((Method)accessibleObject).getName(), Inject.class.getName()));
            }
            if (((Method)accessibleObject).getAnnotation(Autowired.class) == null) continue;
            throw new IllegalStateException(String.format("method %s:%s has %s annotation", cls.getName(), ((Method)accessibleObject).getName(), Autowired.class.getName()));
        }
    }
}

