/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.spi.metrics.PoolMetrics;
import java.util.concurrent.Executor;

public class SyncContext
extends EventLoopContext {
    protected VertxInternal owner;

    public SyncContext() {
        this(null);
    }

    public SyncContext(VertxInternal vertx) {
        super(vertx, null, null, null, null, null, null);
    }

    public VertxInternal owner() {
        return this.owner;
    }

    public void setOwner(VertxInternal owner) {
        this.owner = owner;
    }

    public void runOnContext(Handler<Void> task) {
        task.handle(null);
    }

    public static <T> void syncExecuteBlocking(Handler<Promise<T>> blockingCodeHandler, Handler<AsyncResult<T>> asyncResultHandler) {
        Promise res = Promise.promise();
        try {
            blockingCodeHandler.handle((Object)res);
        }
        catch (Throwable e) {
            res.fail(e);
            return;
        }
        res.future().setHandler(asyncResultHandler);
    }

    public <T> void executeBlockingInternal(Handler<Promise<T>> action, Handler<AsyncResult<T>> resultHandler) {
        SyncContext.syncExecuteBlocking(future -> {
            try {
                action.handle(future);
            }
            catch (Throwable e) {
                future.fail(e);
            }
        }, resultHandler);
    }

    public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> asyncResultHandler) {
        SyncContext.syncExecuteBlocking(blockingCodeHandler, asyncResultHandler);
    }

    <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, Handler<AsyncResult<T>> resultHandler, Executor exec, TaskQueue queue, PoolMetrics metrics) {
        SyncContext.syncExecuteBlocking(blockingCodeHandler, resultHandler);
    }
}

