/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.VertxInternal;

public class SyncContext
extends EventLoopContext {
    protected VertxInternal owner;

    public SyncContext() {
        this(null);
    }

    public SyncContext(VertxInternal vertx) {
        super(vertx, null, null, null, null, null, null);
    }

    public VertxInternal owner() {
        return this.owner;
    }

    public void setOwner(VertxInternal owner) {
        this.owner = owner;
    }

    protected void runOnContext(ContextInternal ctx, Handler<Void> action) {
        action.handle(null);
    }

    public static <T> void syncExecuteBlocking(Handler<Promise<T>> blockingCodeHandler, Handler<AsyncResult<T>> asyncResultHandler) {
        Promise res = Promise.promise();
        try {
            blockingCodeHandler.handle((Object)res);
        }
        catch (Throwable e) {
            res.fail(e);
            return;
        }
        res.future().onComplete(asyncResultHandler);
    }

    private static <T> Future<T> syncExecuteBlocking(Handler<Promise<T>> blockingCodeHandler) {
        Promise res = Promise.promise();
        try {
            blockingCodeHandler.handle((Object)res);
        }
        catch (Throwable e) {
            res.fail(e);
            return res.future();
        }
        res.complete();
        return res.future();
    }

    public <T> Future<T> executeBlockingInternal(Handler<Promise<T>> action) {
        return SyncContext.syncExecuteBlocking(action);
    }

    public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> asyncResultHandler) {
        SyncContext.syncExecuteBlocking(blockingCodeHandler, asyncResultHandler);
    }
}

