/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx;

import io.netty.buffer.ByteBuf;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.VertxImplEx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.SLF4JLogDelegateFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.xml.ws.Holder;
import org.apache.commons.io.IOUtils;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.vertx.AsyncResultCallback;
import org.apache.servicecomb.foundation.vertx.SimpleJsonObject;
import org.apache.servicecomb.foundation.vertx.client.ClientPoolManager;
import org.apache.servicecomb.foundation.vertx.stream.BufferInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VertxUtils {
    private static final Logger LOGGER;
    private static final long BLOCKED_THREAD_CHECK_INTERVAL = 0x3FFFFFFFFFFFFFFFL;
    private static Map<String, VertxImplEx> vertxMap;

    private VertxUtils() {
    }

    public static Map<String, VertxImplEx> getVertxMap() {
        return vertxMap;
    }

    public static <T extends AbstractVerticle> void deployVerticle(Vertx vertx, Class<T> cls, int instanceCount) {
        DeploymentOptions options = new DeploymentOptions().setInstances(instanceCount);
        vertx.deployVerticle(cls.getName(), options);
    }

    public static <CLIENT_POOL> DeploymentOptions createClientDeployOptions(ClientPoolManager<CLIENT_POOL> clientMgr, int instanceCount) {
        DeploymentOptions options = new DeploymentOptions().setInstances(instanceCount);
        SimpleJsonObject config = new SimpleJsonObject();
        config.put("clientMgr", clientMgr);
        options.setConfig((JsonObject)config);
        return options;
    }

    public static <VERTICLE extends AbstractVerticle> boolean blockDeploy(Vertx vertx, Class<VERTICLE> cls, DeploymentOptions options) throws InterruptedException {
        Holder result = new Holder();
        CountDownLatch latch = new CountDownLatch(1);
        vertx.deployVerticle(cls.getName(), options, ar -> {
            result.value = ar.succeeded();
            if (ar.failed()) {
                LOGGER.error("deploy vertx failed, cause ", ar.cause());
            }
            latch.countDown();
        });
        latch.await();
        return (Boolean)result.value;
    }

    public static Vertx getOrCreateVertxByName(String name, VertxOptions vertxOptions) {
        return (Vertx)vertxMap.computeIfAbsent(name, vertxName -> (VertxImplEx)VertxUtils.init(vertxName, vertxOptions));
    }

    public static Vertx init(VertxOptions vertxOptions) {
        return VertxUtils.init(null, vertxOptions);
    }

    public static Vertx init(String name, VertxOptions vertxOptions) {
        boolean isDebug;
        if (vertxOptions == null) {
            vertxOptions = new VertxOptions();
        }
        boolean bl = isDebug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("jdwp") >= 0;
        if (isDebug) {
            vertxOptions.setBlockedThreadCheckInterval(0x3FFFFFFFFFFFFFFFL);
            LOGGER.info("in debug mode, disable blocked thread check.");
        }
        VertxUtils.configureVertxFileCaching();
        return new VertxImplEx(name, vertxOptions);
    }

    protected static void configureVertxFileCaching() {
        if (System.getProperty("vertx.disableFileCPResolving") == null) {
            System.setProperty("vertx.disableFileCPResolving", "true");
        }
    }

    public static Vertx currentVertx() {
        Context context = Vertx.currentContext();
        if (context == null) {
            throw new RuntimeException("get currentVertx error, currentContext is null.");
        }
        return context.owner();
    }

    public static Vertx getVertxByName(String name) {
        return (Vertx)vertxMap.get(name);
    }

    public static <T> void runInContext(Context context, AsyncResultCallback<T> callback, T result, Throwable e) {
        if (context == Vertx.currentContext()) {
            VertxUtils.complete(callback, result, e);
        } else {
            context.runOnContext(v -> VertxUtils.complete(callback, result, e));
        }
    }

    private static <T> void complete(AsyncResultCallback<T> callback, T result, Throwable e) {
        if (e != null) {
            callback.fail(e.getCause());
            return;
        }
        callback.success(result);
    }

    public static byte[] getBytesFast(InputStream inputStream) throws IOException {
        if (BufferInputStream.class.isInstance(inputStream)) {
            return VertxUtils.getBytesFast(((BufferInputStream)((Object)inputStream)).getByteBuf());
        }
        return IOUtils.toByteArray((InputStream)inputStream);
    }

    public static byte[] getBytesFast(Buffer buffer) {
        ByteBuf byteBuf = buffer.getByteBuf();
        return VertxUtils.getBytesFast(byteBuf);
    }

    public static byte[] getBytesFast(ByteBuf byteBuf) {
        if (byteBuf.hasArray()) {
            return byteBuf.array();
        }
        byte[] arr = new byte[byteBuf.writerIndex()];
        byteBuf.getBytes(0, arr);
        return arr;
    }

    static {
        System.setProperty("vertx.logger-delegate-factory-class-name", SLF4JLogDelegateFactory.class.getName());
        io.vertx.core.logging.LoggerFactory.initialise();
        LOGGER = LoggerFactory.getLogger(VertxUtils.class);
        vertxMap = new ConcurrentHashMapEx();
    }
}

