/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.http;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.foundation.common.http.HttpStatus;
import org.apache.servicecomb.foundation.vertx.http.AbstractHttpServletResponse;

public class VertxServerResponseToHttpServletResponse
extends AbstractHttpServletResponse {
    private Context context = Vertx.currentContext();
    private HttpServerResponse serverResponse;
    private Response.StatusType statusType;

    public VertxServerResponseToHttpServletResponse(HttpServerResponse serverResponse) {
        this.serverResponse = serverResponse;
        Objects.requireNonNull(this.context, "must run in vertx context.");
    }

    @Override
    public void setContentType(String type) {
        this.serverResponse.headers().set("Content-Type", type);
    }

    @Override
    public void setStatus(int sc, String sm) {
        this.serverResponse.setStatusCode(sc);
        this.serverResponse.setStatusMessage(sm);
    }

    @Override
    public Response.StatusType getStatusType() {
        if (this.statusType == null) {
            this.statusType = new HttpStatus(this.serverResponse.getStatusCode(), this.serverResponse.getStatusMessage());
        }
        return this.statusType;
    }

    @Override
    public void addHeader(String name, String value) {
        this.serverResponse.headers().add(name, value);
    }

    @Override
    public void setHeader(String name, String value) {
        this.serverResponse.headers().set(name, value);
    }

    @Override
    public int getStatus() {
        return this.serverResponse.getStatusCode();
    }

    @Override
    public String getContentType() {
        return this.serverResponse.headers().get("Content-Type");
    }

    @Override
    public String getHeader(String name) {
        return this.serverResponse.headers().get(name);
    }

    @Override
    public Collection<String> getHeaders(String name) {
        return this.serverResponse.headers().getAll(name);
    }

    @Override
    public Collection<String> getHeaderNames() {
        return this.serverResponse.headers().names();
    }

    @Override
    public void flushBuffer() throws IOException {
        if (this.context == Vertx.currentContext()) {
            this.internalFlushBuffer();
            return;
        }
        this.context.runOnContext(V -> this.internalFlushBuffer());
    }

    public void internalFlushBuffer() {
        if (this.bodyBuffer == null) {
            this.serverResponse.end();
            return;
        }
        this.serverResponse.end(this.bodyBuffer);
    }
}

