/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.http;

import io.vertx.core.http.HttpHeaders;
import java.io.IOException;
import javax.servlet.http.Part;
import org.apache.servicecomb.foundation.common.http.HttpUtils;
import org.apache.servicecomb.foundation.common.part.FilePartForSend;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DownloadUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadUtils.class);

    private DownloadUtils() {
    }

    public static void prepareDownloadHeader(HttpServletResponseEx responseEx, Part part) {
        if (responseEx.getHeader(HttpHeaders.CONTENT_LENGTH.toString()) == null) {
            responseEx.setChunked(true);
        }
        if (part == null) {
            return;
        }
        if (responseEx.getHeader(HttpHeaders.CONTENT_TYPE.toString()) == null) {
            responseEx.setHeader(HttpHeaders.CONTENT_TYPE.toString(), part.getContentType());
        }
        if (responseEx.getHeader("Content-Disposition") == null) {
            String encodedFileName = HttpUtils.uriEncodePath((String)part.getSubmittedFileName());
            responseEx.setHeader("Content-Disposition", "attachment;filename=" + encodedFileName + ";filename*=utf-8''" + encodedFileName);
        }
    }

    public static void clearPartResource(Part part) {
        if (part == null) {
            return;
        }
        if (part instanceof FilePartForSend && ((FilePartForSend)part).isDeleteAfterFinished()) {
            try {
                part.delete();
            }
            catch (IOException e) {
                LOGGER.error("Failed to delete temp file: {}.", (Object)((FilePartForSend)part).getAbsolutePath(), (Object)e);
            }
        }
    }
}

