/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.bizkeeper;

import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.strategy.properties.HystrixDynamicProperty;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesChainedProperty;
import com.netflix.hystrix.strategy.properties.HystrixProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixCommandPropertiesExt
extends HystrixCommandProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(HystrixCommandProperties.class);
    static final Integer DEFAULT_METRICSROLLINGSTATISTICALWINDOW = 10000;
    private static final Integer DEFAULT_METRICSROLLINGSTATISTICALWINDOWBUCKETS = 10;
    private static final Integer DEFAULT_CIRCUITBREAKERREQUESTVOLUMETHRESHOLD = 20;
    private static final Integer DEFAULT_CIRCUITBREAKERSLEEPWINDOWINMILLISECONDS = 15000;
    private static final Integer DEFAULT_CIRCUITBREAKERERRORTHRESHOLDPERCENTAGE = 50;
    private static final Boolean DEFAULT_CIRCUITBREAKERFORCEOPEN = false;
    static final Boolean DEFAULT_CIRCUITBREAKERFORCECLOSED = false;
    private static final Integer DEFAULT_EXECUTIONTIMEOUTINMILLISECONDS = 30000;
    private static final Boolean DEFAULT_EXECUTIONTIMEOUTENABLED = false;
    private static final HystrixCommandProperties.ExecutionIsolationStrategy DEFAULT_ISOLATIONSTRATEGY = HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE;
    private static final Boolean DEFAULT_EXECUTIONISOLATIONTHREADINTERRUPTONTIMEOUT = true;
    private static final Boolean DEFAULT_METRICSROLLINGPERCENTILEENABLED = false;
    private static final Boolean DEFAULT_REQUESTCACHEENABLED = true;
    private static final Integer DEFAULT_FALLBACKISOLATIONSEMAPHOREMAXCONCURRENTREQUESTS = 10;
    private static final Boolean DEFAULT_FALLBACKENABLED = true;
    private static final Integer DEFAULT_EXECUTIONISOLATIONSEMAPHOREMAXCONCURRENTREQUESTS = 1000;
    private static final Boolean DEFAULT_REQUESTLOGENABLED = true;
    private static final Boolean DEFAULT_CIRCUITBREAKERENABLED = true;
    private static final Integer DEFAULT_METRICSROLLINGPERCENTILEWINDOW = 60000;
    private static final Integer DEFAULT_METRICSROLLINGPERCENTILEWINDOWBUCKETS = 6;
    private static final Integer DEFAULT_METRICSROLLINGPERCENTILEBUCKETSIZE = 100;
    private static final Integer DEFAULT_METRICSHEALTHSNAPSHOTINTERVALINMILLISECONDS = 1000;
    private static final int COMMAND_KEY_LENGTH = 3;
    private final HystrixCommandKey key;
    private final HystrixProperty<Integer> circuitBreakerRequestVolumeThreshold;
    private final HystrixProperty<Integer> circuitBreakerSleepWindowInMilliseconds;
    private final HystrixProperty<Boolean> circuitBreakerEnabled;
    private final HystrixProperty<Integer> circuitBreakerErrorThresholdPercentage;
    private final HystrixProperty<Boolean> circuitBreakerForceOpen;
    private final HystrixProperty<Boolean> circuitBreakerForceClosed;
    private final HystrixProperty<HystrixCommandProperties.ExecutionIsolationStrategy> executionIsolationStrategy;
    private final HystrixProperty<Integer> executionTimeoutInMilliseconds;
    private final HystrixProperty<Boolean> executionTimeoutEnabled;
    private final HystrixProperty<String> executionIsolationThreadPoolKeyOverride;
    private final HystrixProperty<Integer> executionIsolationSemaphoreMaxConcurrentRequests;
    private final HystrixProperty<Integer> fallbackIsolationSemaphoreMaxConcurrentRequests;
    private final HystrixProperty<Boolean> fallbackEnabled;
    private final HystrixProperty<Boolean> executionIsolationThreadInterruptOnTimeout;
    private final HystrixProperty<Integer> metricsRollingStatisticalWindowInMilliseconds;
    private final HystrixProperty<Integer> metricsRollingStatisticalWindowBuckets;
    private final HystrixProperty<Boolean> metricsRollingPercentileEnabled;
    private final HystrixProperty<Integer> metricsRollingPercentileWindowInMilliseconds;
    private final HystrixProperty<Integer> metricsRollingPercentileWindowBuckets;
    private final HystrixProperty<Integer> metricsRollingPercentileBucketSize;
    private final HystrixProperty<Integer> metricsHealthSnapshotIntervalInMilliseconds;
    private final HystrixProperty<Boolean> requestLogEnabled;
    private final HystrixProperty<Boolean> requestCacheEnabled;

    protected HystrixCommandPropertiesExt(HystrixCommandKey key) {
        this(key, HystrixCommandProperties.Setter(), "cse");
    }

    protected HystrixCommandPropertiesExt(HystrixCommandKey key, HystrixCommandProperties.Setter builder) {
        this(key, builder, "cse");
    }

    protected HystrixCommandPropertiesExt(HystrixCommandKey key, HystrixCommandProperties.Setter builder, String propertyPrefix) {
        super(key, builder, propertyPrefix);
        this.key = key;
        this.circuitBreakerEnabled = this.getProperty(propertyPrefix, "circuitBreaker", key, "enabled", builder.getCircuitBreakerEnabled(), DEFAULT_CIRCUITBREAKERENABLED);
        this.circuitBreakerRequestVolumeThreshold = this.getProperty(propertyPrefix, "circuitBreaker", key, "requestVolumeThreshold", builder.getCircuitBreakerRequestVolumeThreshold(), DEFAULT_CIRCUITBREAKERREQUESTVOLUMETHRESHOLD);
        this.circuitBreakerSleepWindowInMilliseconds = this.getProperty(propertyPrefix, "circuitBreaker", key, "sleepWindowInMilliseconds", builder.getCircuitBreakerSleepWindowInMilliseconds(), DEFAULT_CIRCUITBREAKERSLEEPWINDOWINMILLISECONDS);
        this.circuitBreakerErrorThresholdPercentage = this.getProperty(propertyPrefix, "circuitBreaker", key, "errorThresholdPercentage", builder.getCircuitBreakerErrorThresholdPercentage(), DEFAULT_CIRCUITBREAKERERRORTHRESHOLDPERCENTAGE);
        this.circuitBreakerForceOpen = this.getProperty(propertyPrefix, "circuitBreaker", key, "forceOpen", builder.getCircuitBreakerForceOpen(), DEFAULT_CIRCUITBREAKERFORCEOPEN);
        this.circuitBreakerForceClosed = this.getProperty(propertyPrefix, "circuitBreaker", key, "forceClosed", builder.getCircuitBreakerForceClosed(), DEFAULT_CIRCUITBREAKERFORCECLOSED);
        this.executionIsolationStrategy = this.getProperty(propertyPrefix, "isolation", key, "strategy", builder.getExecutionIsolationStrategy(), DEFAULT_ISOLATIONSTRATEGY);
        this.executionTimeoutInMilliseconds = this.getProperty(propertyPrefix, "isolation", key, "timeoutInMilliseconds", builder.getExecutionTimeoutInMilliseconds(), DEFAULT_EXECUTIONTIMEOUTINMILLISECONDS);
        this.executionTimeoutEnabled = this.getProperty(propertyPrefix, "isolation", key, "timeout.enabled", builder.getExecutionTimeoutEnabled(), DEFAULT_EXECUTIONTIMEOUTENABLED);
        this.executionIsolationThreadInterruptOnTimeout = this.getProperty(propertyPrefix, "isolation", key, "interruptOnTimeout", builder.getExecutionIsolationThreadInterruptOnTimeout(), DEFAULT_EXECUTIONISOLATIONTHREADINTERRUPTONTIMEOUT);
        this.executionIsolationSemaphoreMaxConcurrentRequests = this.getProperty(propertyPrefix, "isolation", key, "maxConcurrentRequests", builder.getExecutionIsolationSemaphoreMaxConcurrentRequests(), DEFAULT_EXECUTIONISOLATIONSEMAPHOREMAXCONCURRENTREQUESTS);
        this.fallbackIsolationSemaphoreMaxConcurrentRequests = this.getProperty(propertyPrefix, "fallback", key, "maxConcurrentRequests", builder.getFallbackIsolationSemaphoreMaxConcurrentRequests(), DEFAULT_FALLBACKISOLATIONSEMAPHOREMAXCONCURRENTREQUESTS);
        this.fallbackEnabled = this.getProperty(propertyPrefix, "fallback", key, "enabled", builder.getFallbackEnabled(), DEFAULT_FALLBACKENABLED);
        this.metricsRollingStatisticalWindowInMilliseconds = this.getProperty(propertyPrefix, "metrics", key, "rollingStats.timeInMilliseconds", builder.getMetricsRollingStatisticalWindowInMilliseconds(), DEFAULT_METRICSROLLINGSTATISTICALWINDOW);
        this.metricsRollingStatisticalWindowBuckets = this.getProperty(propertyPrefix, "metrics", key, "rollingStats.numBuckets", builder.getMetricsRollingStatisticalWindowBuckets(), DEFAULT_METRICSROLLINGSTATISTICALWINDOWBUCKETS);
        this.metricsRollingPercentileEnabled = this.getProperty(propertyPrefix, "metrics", key, "rollingPercentile.enabled", builder.getMetricsRollingPercentileEnabled(), DEFAULT_METRICSROLLINGPERCENTILEENABLED);
        this.metricsRollingPercentileWindowInMilliseconds = this.getProperty(propertyPrefix, "metrics", key, "rollingPercentile.timeInMilliseconds", builder.getMetricsRollingPercentileWindowInMilliseconds(), DEFAULT_METRICSROLLINGPERCENTILEWINDOW);
        this.metricsRollingPercentileWindowBuckets = this.getProperty(propertyPrefix, "metrics", key, "rollingPercentile.numBuckets", builder.getMetricsRollingPercentileWindowBuckets(), DEFAULT_METRICSROLLINGPERCENTILEWINDOWBUCKETS);
        this.metricsRollingPercentileBucketSize = this.getProperty(propertyPrefix, "metrics", key, "rollingPercentile.bucketSize", builder.getMetricsRollingPercentileBucketSize(), DEFAULT_METRICSROLLINGPERCENTILEBUCKETSIZE);
        this.metricsHealthSnapshotIntervalInMilliseconds = this.getProperty(propertyPrefix, "metrics", key, "healthSnapshot.intervalInMilliseconds", builder.getMetricsHealthSnapshotIntervalInMilliseconds(), DEFAULT_METRICSHEALTHSNAPSHOTINTERVALINMILLISECONDS);
        this.requestCacheEnabled = this.getProperty(propertyPrefix, "requestCache", key, "enabled", builder.getRequestCacheEnabled(), DEFAULT_REQUESTCACHEENABLED);
        this.requestLogEnabled = this.getProperty(propertyPrefix, "requestLog", key, "enabled", builder.getRequestLogEnabled(), DEFAULT_REQUESTLOGENABLED);
        this.executionIsolationThreadPoolKeyOverride = HystrixPropertiesChainedProperty.forString().add(propertyPrefix + ".command." + key.name() + ".threadPoolKeyOverride", null).build();
    }

    public HystrixProperty<Boolean> circuitBreakerEnabled() {
        return this.circuitBreakerEnabled;
    }

    public HystrixProperty<Integer> circuitBreakerErrorThresholdPercentage() {
        return this.circuitBreakerErrorThresholdPercentage;
    }

    public HystrixProperty<Boolean> circuitBreakerForceClosed() {
        return this.circuitBreakerForceClosed;
    }

    public HystrixProperty<Boolean> circuitBreakerForceOpen() {
        return this.circuitBreakerForceOpen;
    }

    public HystrixProperty<Integer> circuitBreakerRequestVolumeThreshold() {
        return this.circuitBreakerRequestVolumeThreshold;
    }

    public HystrixProperty<Integer> circuitBreakerSleepWindowInMilliseconds() {
        return this.circuitBreakerSleepWindowInMilliseconds;
    }

    public HystrixProperty<Integer> executionIsolationSemaphoreMaxConcurrentRequests() {
        return this.executionIsolationSemaphoreMaxConcurrentRequests;
    }

    public HystrixProperty<HystrixCommandProperties.ExecutionIsolationStrategy> executionIsolationStrategy() {
        return this.executionIsolationStrategy;
    }

    public HystrixProperty<Boolean> executionIsolationThreadInterruptOnTimeout() {
        return this.executionIsolationThreadInterruptOnTimeout;
    }

    public HystrixProperty<String> executionIsolationThreadPoolKeyOverride() {
        return this.executionIsolationThreadPoolKeyOverride;
    }

    @Deprecated
    public HystrixProperty<Integer> executionIsolationThreadTimeoutInMilliseconds() {
        return this.executionTimeoutInMilliseconds;
    }

    public HystrixProperty<Integer> executionTimeoutInMilliseconds() {
        return this.executionIsolationThreadTimeoutInMilliseconds();
    }

    public HystrixProperty<Boolean> executionTimeoutEnabled() {
        return this.executionTimeoutEnabled;
    }

    public HystrixProperty<Integer> fallbackIsolationSemaphoreMaxConcurrentRequests() {
        return this.fallbackIsolationSemaphoreMaxConcurrentRequests;
    }

    public HystrixProperty<Boolean> fallbackEnabled() {
        return this.fallbackEnabled;
    }

    public HystrixProperty<Integer> metricsHealthSnapshotIntervalInMilliseconds() {
        return this.metricsHealthSnapshotIntervalInMilliseconds;
    }

    public HystrixProperty<Integer> metricsRollingPercentileBucketSize() {
        return this.metricsRollingPercentileBucketSize;
    }

    public HystrixProperty<Boolean> metricsRollingPercentileEnabled() {
        return this.metricsRollingPercentileEnabled;
    }

    @Deprecated
    public HystrixProperty<Integer> metricsRollingPercentileWindow() {
        return this.metricsRollingPercentileWindowInMilliseconds;
    }

    public HystrixProperty<Integer> metricsRollingPercentileWindowInMilliseconds() {
        return this.metricsRollingPercentileWindowInMilliseconds;
    }

    public HystrixProperty<Integer> metricsRollingPercentileWindowBuckets() {
        return this.metricsRollingPercentileWindowBuckets;
    }

    public HystrixProperty<Integer> metricsRollingStatisticalWindowInMilliseconds() {
        return this.metricsRollingStatisticalWindowInMilliseconds;
    }

    public HystrixProperty<Integer> metricsRollingStatisticalWindowBuckets() {
        return this.metricsRollingStatisticalWindowBuckets;
    }

    public HystrixProperty<Boolean> requestCacheEnabled() {
        return this.requestCacheEnabled;
    }

    public HystrixProperty<Boolean> requestLogEnabled() {
        return this.requestLogEnabled;
    }

    private HystrixProperty<HystrixCommandProperties.ExecutionIsolationStrategy> getProperty(String propertyPrefix, String command, HystrixCommandKey key, String instanceProperty, HystrixCommandProperties.ExecutionIsolationStrategy builderOverrideValue, HystrixCommandProperties.ExecutionIsolationStrategy defaultValue) {
        return new ExecutionIsolationStrategyHystrixProperty(builderOverrideValue, key, propertyPrefix, command, defaultValue, instanceProperty);
    }

    private static String serviceKey(String key) {
        String[] keyparts = key.split("\\.", 3);
        if (keyparts.length == 3) {
            return keyparts[0] + "." + keyparts[1];
        }
        return key;
    }

    private static String typeKey(String key) {
        int index = key.indexOf(".");
        if (index > 0) {
            return key.substring(0, index);
        }
        return key;
    }

    private HystrixProperty<Integer> getProperty(String propertyPrefix, String command, HystrixCommandKey key, String instanceProperty, Integer builderOverrideValue, Integer defaultValue) {
        return HystrixPropertiesChainedProperty.forInteger().add(propertyPrefix + "." + command + "." + key.name() + "." + instanceProperty, null).add(propertyPrefix + "." + command + "." + HystrixCommandPropertiesExt.serviceKey(key.name()) + "." + instanceProperty, null).add(propertyPrefix + "." + command + "." + HystrixCommandPropertiesExt.typeKey(key.name()) + "." + instanceProperty, (Object)(builderOverrideValue == null ? defaultValue : builderOverrideValue)).build();
    }

    private HystrixProperty<Boolean> getProperty(String propertyPrefix, String command, HystrixCommandKey key, String instanceProperty, Boolean builderOverrideValue, Boolean defaultValue) {
        return HystrixPropertiesChainedProperty.forBoolean().add(propertyPrefix + "." + command + "." + key.name() + "." + instanceProperty, null).add(propertyPrefix + "." + command + "." + HystrixCommandPropertiesExt.serviceKey(key.name()) + "." + instanceProperty, null).add(propertyPrefix + "." + command + "." + HystrixCommandPropertiesExt.typeKey(key.name()) + "." + instanceProperty, (Object)(builderOverrideValue == null ? defaultValue : builderOverrideValue)).build();
    }

    private static final class ExecutionIsolationStrategyHystrixProperty
    implements HystrixProperty<HystrixCommandProperties.ExecutionIsolationStrategy> {
        private final HystrixDynamicProperty<String> property;
        private volatile HystrixCommandProperties.ExecutionIsolationStrategy value;
        private final HystrixCommandProperties.ExecutionIsolationStrategy defaultValue;

        private ExecutionIsolationStrategyHystrixProperty(HystrixCommandProperties.ExecutionIsolationStrategy builderOverrideValue, HystrixCommandKey key, String propertyPrefix, String command, HystrixCommandProperties.ExecutionIsolationStrategy defaultValue, String instanceProperty) {
            this.defaultValue = defaultValue;
            String overrideValue = null;
            if (builderOverrideValue != null) {
                overrideValue = builderOverrideValue.name();
            }
            this.property = HystrixPropertiesChainedProperty.forString().add(propertyPrefix + "." + command + "." + key.name() + "." + instanceProperty, null).add(propertyPrefix + "." + command + "." + HystrixCommandPropertiesExt.serviceKey(key.name()) + "." + instanceProperty, (Object)overrideValue).add(propertyPrefix + "." + command + "." + HystrixCommandPropertiesExt.typeKey(key.name()) + "." + instanceProperty, (Object)defaultValue.name()).build();
            this.parseProperty();
            this.property.addCallback(this::parseProperty);
        }

        public HystrixCommandProperties.ExecutionIsolationStrategy get() {
            return this.value;
        }

        private void parseProperty() {
            try {
                this.value = HystrixCommandProperties.ExecutionIsolationStrategy.valueOf((String)((String)this.property.get()));
            }
            catch (Exception e) {
                LOGGER.error("Unable to derive ExecutionIsolationStrategy from property value: " + (String)this.property.get(), (Throwable)e);
                this.value = this.defaultValue;
            }
        }
    }
}

