/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.qps.strategy;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.servicecomb.qps.strategy.AbstractQpsStrategy;

public class FixedWindowStrategy
extends AbstractQpsStrategy {
    private volatile long msCycleBegin;
    private AtomicLong requestCount = new AtomicLong();
    private volatile long lastRequestCount = 1L;
    private static final int CYCLE_LENGTH = 1000;
    private static final String STRATEGY_NAME = "FixedWindow";

    @Override
    public boolean isLimitNewRequest() {
        if (this.getQpsLimit() == null) {
            this.setQpsLimit(Long.MAX_VALUE);
        }
        long newCount = this.requestCount.incrementAndGet();
        long msNow = System.currentTimeMillis();
        if (msNow - this.msCycleBegin > 1000L || msNow < this.msCycleBegin) {
            this.lastRequestCount = newCount;
            this.msCycleBegin = msNow;
        }
        return newCount - this.lastRequestCount >= this.getQpsLimit();
    }

    @Override
    public String name() {
        return STRATEGY_NAME;
    }
}

