/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.alpha.fsm.channel.kafka;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.servicecomb.pack.alpha.core.fsm.sink.ActorEventSink;
import org.apache.servicecomb.pack.alpha.fsm.channel.kafka.KafkaMessageListener;
import org.apache.servicecomb.pack.alpha.fsm.channel.kafka.KafkaMessagePublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaAdmin;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.support.serializer.JsonDeserializer;
import org.springframework.kafka.support.serializer.JsonSerializer;

@Configuration
@ConditionalOnClass(value={KafkaProperties.class})
@ConditionalOnProperty(value={"alpha.feature.akka.channel.type"}, havingValue="kafka")
public class KafkaChannelAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(KafkaChannelAutoConfiguration.class);
    @Value(value="${alpha.feature.akka.channel.kafka.topic:servicecomb-pack-actor-event}")
    private String topic;
    @Value(value="${spring.kafka.bootstrap-servers}")
    private String bootstrap_servers;
    @Value(value="${spring.kafka.consumer.group-id:servicecomb-pack}")
    private String groupId;
    @Value(value="${spring.kafka.consumer.properties.spring.json.trusted.packages:org.apache.servicecomb.pack.alpha.core.fsm.event,org.apache.servicecomb.pack.alpha.core.fsm.event.base,}org.apache.servicecomb.pack.alpha.core.fsm.event.internal")
    private String trusted_packages;
    @Value(value="${spring.kafka.producer.batch-size:16384}")
    private int batchSize;
    @Value(value="${spring.kafka.producer.retries:0}")
    private int retries;
    @Value(value="${spring.kafka.producer.buffer.memory:33554432}")
    private long bufferMemory;
    @Value(value="${spring.kafka.consumer.auto.offset.reset:earliest}")
    private String autoOffsetReset;
    @Value(value="${spring.kafka.consumer.enable.auto.commit:false}")
    private boolean enableAutoCommit;
    @Value(value="${spring.kafka.consumer.auto.commit.interval.ms:100}")
    private int autoCommitIntervalMs;
    @Value(value="${spring.kafka.listener.ackMode:MANUAL_IMMEDIATE}")
    private String ackMode;
    @Value(value="${spring.kafka.listener.pollTimeout:1500}")
    private long poolTimeout;
    @Value(value="${kafka.numPartitions:6}")
    private int numPartitions;
    @Value(value="${kafka.replicationFactor:1}")
    private short replicationFactor;

    @Bean
    @ConditionalOnMissingBean
    public ProducerFactory<String, Object> producerFactory() {
        HashMap map = Maps.newHashMap();
        map.put("bootstrap.servers", this.bootstrap_servers);
        map.put("key.serializer", StringSerializer.class);
        map.put("value.serializer", JsonSerializer.class);
        map.put("retries", this.retries);
        map.put("batch.size", this.batchSize);
        map.put("buffer.memory", this.bufferMemory);
        return new DefaultKafkaProducerFactory((Map)map);
    }

    @Bean
    @ConditionalOnMissingBean
    public KafkaTemplate<String, Object> kafkaTemplate() {
        return new KafkaTemplate(this.producerFactory());
    }

    @Bean
    @ConditionalOnMissingBean
    public ConsumerFactory<String, Object> consumerFactory() {
        HashMap map = Maps.newHashMap();
        map.put("bootstrap.servers", this.bootstrap_servers);
        map.put("group.id", this.groupId);
        map.put("key.deserializer", StringDeserializer.class);
        map.put("value.deserializer", JsonDeserializer.class);
        map.put("auto.offset.reset", this.autoOffsetReset);
        map.put("enable.auto.commit", this.enableAutoCommit);
        map.put("auto.commit.interval.ms", this.autoCommitIntervalMs);
        map.put("spring.json.trusted.packages", this.trusted_packages);
        if (logger.isDebugEnabled()) {
            logger.debug("init consumerFactory properties = [{}]", (Object)map);
        }
        return new DefaultKafkaConsumerFactory((Map)map);
    }

    @Bean
    @ConditionalOnMissingBean
    public KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<String, Object>> kafkaListenerContainerFactory() {
        ConcurrentKafkaListenerContainerFactory concurrentKafkaListenerContainerFactory = new ConcurrentKafkaListenerContainerFactory();
        concurrentKafkaListenerContainerFactory.setConsumerFactory(this.consumerFactory());
        concurrentKafkaListenerContainerFactory.getContainerProperties().setPollTimeout(this.poolTimeout);
        concurrentKafkaListenerContainerFactory.getContainerProperties().setAckMode(ContainerProperties.AckMode.valueOf((String)this.ackMode));
        return concurrentKafkaListenerContainerFactory;
    }

    @Bean
    @ConditionalOnMissingBean
    public KafkaMessagePublisher kafkaMessagePublisher(KafkaTemplate<String, Object> kafkaTemplate) {
        return new KafkaMessagePublisher(this.topic, kafkaTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public KafkaMessageListener kafkaMessageListener(@Lazy @Qualifier(value="actorEventSink") ActorEventSink actorEventSink) {
        return new KafkaMessageListener(actorEventSink);
    }

    @Bean
    @ConditionalOnMissingBean
    public KafkaAdmin kafkaAdmin() {
        HashMap map = Maps.newHashMap();
        map.put("bootstrap.servers", this.bootstrap_servers);
        return new KafkaAdmin((Map)map);
    }

    @Bean
    @ConditionalOnMissingBean
    public NewTopic newTopic() {
        return new NewTopic(this.topic, this.numPartitions, this.replicationFactor);
    }
}

