/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.alpha.fsm.channel.kafka;

import org.apache.servicecomb.pack.alpha.core.fsm.event.base.BaseEvent;
import org.apache.servicecomb.pack.alpha.core.fsm.sink.ActorEventSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;

public class KafkaMessageListener {
    private static final Logger logger = LoggerFactory.getLogger(KafkaMessageListener.class);
    private ActorEventSink actorEventSink;

    public KafkaMessageListener(ActorEventSink actorEventSink) {
        this.actorEventSink = actorEventSink;
    }

    @KafkaListener(topics={"${alpha.feature.akka.channel.kafka.topic:servicecomb-pack-actor-event}"})
    public void listener(BaseEvent baseEvent, Acknowledgment acknowledgment) {
        if (logger.isDebugEnabled()) {
            logger.debug("listener event = [{}]", (Object)baseEvent);
        }
        try {
            this.actorEventSink.send(baseEvent);
            acknowledgment.acknowledge();
        }
        catch (Exception e) {
            logger.error("subscriber Exception = [{}]", (Object)e.getMessage(), (Object)e);
        }
    }
}

