/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.alpha.fsm.channel.kafka;

import java.util.concurrent.ExecutionException;
import org.apache.servicecomb.pack.alpha.core.fsm.channel.MessagePublisher;
import org.apache.servicecomb.pack.alpha.core.fsm.event.base.BaseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;

public class KafkaMessagePublisher
implements MessagePublisher {
    private static final Logger logger = LoggerFactory.getLogger(KafkaMessagePublisher.class);
    private String topic;
    private KafkaTemplate<String, Object> kafkaTemplate;

    public KafkaMessagePublisher(String topic, KafkaTemplate<String, Object> kafkaTemplate) {
        this.topic = topic;
        this.kafkaTemplate = kafkaTemplate;
    }

    public void publish(Object data) {
        if (logger.isDebugEnabled()) {
            logger.debug("send message [{}] to [{}]", data, (Object)this.topic);
        }
        try {
            if (!(data instanceof BaseEvent)) {
                throw new UnsupportedOperationException("data must be BaseEvent type");
            }
            BaseEvent event = (BaseEvent)data;
            this.kafkaTemplate.send(this.topic, (Object)event.getGlobalTxId(), (Object)event).get();
        }
        catch (InterruptedException | UnsupportedOperationException | ExecutionException e) {
            logger.error("publish Exception = [{}]", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }
}

