/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.alpha.server.discovery.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.agent.model.NewService;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.lang.invoke.MethodHandles;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.servicecomb.pack.alpha.core.event.GrpcStartableStartedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.consul.ConsulAutoConfiguration;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"spring.cloud.consul.enabled"})
@AutoConfigureAfter(value={ConsulAutoConfiguration.class})
public class AlphaConsulAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String consuleInstanceId;
    private int actualAlphaServerPort;
    @Value(value="${alpha.server.port}")
    private int alphaServerPort;
    @Value(value="${spring.application.name}")
    private String serviceName;
    @Autowired
    private ConsulClient consulClient;
    @Autowired
    @Qualifier(value="alphaEventBus")
    EventBus eventBus;
    @Autowired
    ConsulDiscoveryProperties consulDiscoveryProperties;

    @PostConstruct
    public void init() {
        this.eventBus.register((Object)this);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                LOG.info("Unregister Consul {}", (Object)AlphaConsulAutoConfiguration.this.consuleInstanceId);
                AlphaConsulAutoConfiguration.this.consulClient.agentServiceDeregister(AlphaConsulAutoConfiguration.this.consuleInstanceId);
            }
        });
    }

    private String formatConsulInstanceId(String consuleInstanceId) {
        return consuleInstanceId.replace(".", "-").replace(":", "-");
    }

    @Subscribe
    public void listenGrpcStartableStartedEvent(GrpcStartableStartedEvent grpcStartableStartedEvent) {
        if (this.alphaServerPort == 0) {
            this.actualAlphaServerPort = grpcStartableStartedEvent.getPort();
        }
    }

    @EventListener
    public void listenInstanceRegisteredEvent(InstanceRegisteredEvent instanceRegisteredEvent) {
        if (this.alphaServerPort == 0 && instanceRegisteredEvent.getConfig() instanceof ConsulDiscoveryProperties) {
            ConsulDiscoveryProperties properties = (ConsulDiscoveryProperties)instanceRegisteredEvent.getConfig();
            this.consuleInstanceId = this.formatConsulInstanceId(properties.getInstanceId());
            Response services = this.consulClient.getCatalogService(this.serviceName, null);
            if (services.getValue() != null) {
                ((List)services.getValue()).stream().filter(service -> service.getServiceId().equalsIgnoreCase(this.consuleInstanceId)).forEach(service -> {
                    NewService newservice = new NewService();
                    newservice.setName(service.getServiceName());
                    newservice.setId(service.getServiceId());
                    List tags = this.consulDiscoveryProperties.getTags();
                    tags.remove("alpha-server-port=0");
                    tags.add("alpha-server-port=" + this.actualAlphaServerPort);
                    newservice.setTags(tags);
                    this.consulClient.agentServiceRegister(newservice);
                });
            }
        }
    }
}

