/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.spring;

import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.apache.servicecomb.pack.omega.connector.grpc.AlphaClusterConfig;
import org.apache.servicecomb.pack.omega.connector.grpc.AlphaClusterDiscovery;
import org.apache.servicecomb.pack.omega.connector.grpc.core.FastestSender;
import org.apache.servicecomb.pack.omega.connector.grpc.core.LoadBalanceContext;
import org.apache.servicecomb.pack.omega.connector.grpc.core.LoadBalanceContextBuilder;
import org.apache.servicecomb.pack.omega.connector.grpc.core.MessageSenderPicker;
import org.apache.servicecomb.pack.omega.connector.grpc.core.TransactionType;
import org.apache.servicecomb.pack.omega.connector.grpc.saga.SagaLoadBalanceSender;
import org.apache.servicecomb.pack.omega.connector.grpc.tcc.TccLoadBalanceSender;
import org.apache.servicecomb.pack.omega.context.CallbackContext;
import org.apache.servicecomb.pack.omega.context.IdGenerator;
import org.apache.servicecomb.pack.omega.context.OmegaContext;
import org.apache.servicecomb.pack.omega.context.ServiceConfig;
import org.apache.servicecomb.pack.omega.context.UniqueIdGenerator;
import org.apache.servicecomb.pack.omega.format.KryoMessageFormat;
import org.apache.servicecomb.pack.omega.transaction.MessageDeserializer;
import org.apache.servicecomb.pack.omega.transaction.MessageHandler;
import org.apache.servicecomb.pack.omega.transaction.MessageSerializer;
import org.apache.servicecomb.pack.omega.transaction.SagaMessageSender;
import org.apache.servicecomb.pack.omega.transaction.tcc.DefaultParametersContext;
import org.apache.servicecomb.pack.omega.transaction.tcc.ParametersContext;
import org.apache.servicecomb.pack.omega.transaction.tcc.TccMessageHandler;
import org.apache.servicecomb.pack.omega.transaction.tcc.TccMessageSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@ConditionalOnProperty(value={"alpha.cluster.address"})
class OmegaSpringConfig {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    OmegaSpringConfig() {
    }

    @Bean(name={"omegaUniqueIdGenerator"})
    IdGenerator<String> idGenerator() {
        return new UniqueIdGenerator();
    }

    @Bean
    OmegaContext omegaContext(@Qualifier(value="omegaUniqueIdGenerator") IdGenerator<String> idGenerator) {
        return new OmegaContext(idGenerator);
    }

    @Bean(name={"compensationContext"})
    CallbackContext compensationContext(OmegaContext omegaContext) {
        return new CallbackContext(omegaContext);
    }

    @Bean(name={"coordinateContext"})
    CallbackContext coordinateContext(OmegaContext omegaContext) {
        return new CallbackContext(omegaContext);
    }

    @Bean
    ServiceConfig serviceConfig(@Value(value="${spring.application.name}") String serviceName, @Value(value="${omega.instance.instanceId:#{null}}") String instanceId) {
        return new ServiceConfig(serviceName, instanceId);
    }

    @Bean
    ParametersContext parametersContext() {
        return new DefaultParametersContext();
    }

    @Bean
    @ConditionalOnProperty(name={"alpha.cluster.register.type"}, havingValue="default", matchIfMissing=true)
    AlphaClusterDiscovery alphaClusterAddress(@Value(value="${alpha.cluster.address:localhost:8080}") String[] addresses) {
        return AlphaClusterDiscovery.builder().addresses(addresses).build();
    }

    @Bean
    AlphaClusterConfig alphaClusterConfig(@Value(value="${alpha.cluster.ssl.enable:false}") boolean enableSSL, @Value(value="${alpha.cluster.ssl.mutualAuth:false}") boolean mutualAuth, @Value(value="${alpha.cluster.ssl.cert:client.crt}") String cert, @Value(value="${alpha.cluster.ssl.key:client.pem}") String key, @Value(value="${alpha.cluster.ssl.certChain:ca.crt}") String certChain, @Lazy AlphaClusterDiscovery alphaClusterDiscovery, @Lazy MessageHandler handler, @Lazy TccMessageHandler tccMessageHandler) {
        LOG.info("Discovery alpha cluster address {} from {}", (Object)(alphaClusterDiscovery.getAddresses() == null ? "" : String.join((CharSequence)",", alphaClusterDiscovery.getAddresses())), (Object)alphaClusterDiscovery.getDiscoveryType().name());
        KryoMessageFormat messageFormat = new KryoMessageFormat();
        AlphaClusterConfig clusterConfig = AlphaClusterConfig.builder().addresses((List)ImmutableList.copyOf((Object[])alphaClusterDiscovery.getAddresses())).enableSSL(enableSSL).enableMutualAuth(mutualAuth).cert(cert).key(key).certChain(certChain).messageDeserializer((MessageDeserializer)messageFormat).messageSerializer((MessageSerializer)messageFormat).messageHandler(handler).tccMessageHandler(tccMessageHandler).build();
        return clusterConfig;
    }

    @Bean(name={"sagaLoadContext"})
    LoadBalanceContext sagaLoadBalanceSenderContext(AlphaClusterConfig alphaClusterConfig, ServiceConfig serviceConfig, @Value(value="${omega.connection.reconnectDelay:3000}") int reconnectDelay, @Value(value="${omega.connection.sending.timeout:8}") int timeoutSeconds) {
        LoadBalanceContext loadBalanceSenderContext = new LoadBalanceContextBuilder(TransactionType.SAGA, alphaClusterConfig, serviceConfig, reconnectDelay, timeoutSeconds).build();
        return loadBalanceSenderContext;
    }

    @Bean
    SagaMessageSender sagaLoadBalanceSender(@Qualifier(value="sagaLoadContext") LoadBalanceContext loadBalanceSenderContext) {
        SagaLoadBalanceSender sagaMessageSender = new SagaLoadBalanceSender(loadBalanceSenderContext, (MessageSenderPicker)new FastestSender());
        sagaMessageSender.onConnected();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable((SagaMessageSender)sagaMessageSender){
            final /* synthetic */ SagaMessageSender val$sagaMessageSender;
            {
                this.val$sagaMessageSender = sagaMessageSender;
            }

            @Override
            public void run() {
                this.val$sagaMessageSender.onDisconnected();
                this.val$sagaMessageSender.close();
            }
        }));
        return sagaMessageSender;
    }

    @Bean(name={"tccLoadContext"})
    LoadBalanceContext loadBalanceSenderContext(AlphaClusterConfig alphaClusterConfig, ServiceConfig serviceConfig, @Value(value="${omega.connection.reconnectDelay:3000}") int reconnectDelay, @Value(value="${omega.connection.sending.timeout:8}") int timeoutSeconds) {
        LoadBalanceContext loadBalanceSenderContext = new LoadBalanceContextBuilder(TransactionType.TCC, alphaClusterConfig, serviceConfig, reconnectDelay, timeoutSeconds).build();
        return loadBalanceSenderContext;
    }

    @Bean
    TccMessageSender tccLoadBalanceSender(@Qualifier(value="tccLoadContext") LoadBalanceContext loadBalanceSenderContext) {
        TccLoadBalanceSender tccMessageSender = new TccLoadBalanceSender(loadBalanceSenderContext, (MessageSenderPicker)new FastestSender());
        tccMessageSender.onConnected();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable((TccMessageSender)tccMessageSender){
            final /* synthetic */ TccMessageSender val$tccMessageSender;
            {
                this.val$tccMessageSender = tccMessageSender;
            }

            @Override
            public void run() {
                this.val$tccMessageSender.onDisconnected();
                this.val$tccMessageSender.close();
            }
        }));
        return tccMessageSender;
    }
}

