/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.transaction.spring;

import org.apache.servicecomb.pack.omega.context.CallbackContext;
import org.apache.servicecomb.pack.omega.context.OmegaContext;
import org.apache.servicecomb.pack.omega.transaction.spring.CompensableMethodCheckingCallback;
import org.apache.servicecomb.pack.omega.transaction.spring.ExecutorFieldCallback;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ReflectionUtils;

class CompensableAnnotationProcessor
implements BeanPostProcessor {
    private final OmegaContext omegaContext;
    private final CallbackContext compensationContext;

    CompensableAnnotationProcessor(OmegaContext omegaContext, CallbackContext compensationContext) {
        this.omegaContext = omegaContext;
        this.compensationContext = compensationContext;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        this.checkMethod(bean);
        this.checkFields(bean);
        return bean;
    }

    private void checkMethod(Object bean) {
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)new CompensableMethodCheckingCallback(bean, this.compensationContext));
    }

    private void checkFields(Object bean) {
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ExecutorFieldCallback(bean, this.omegaContext));
    }
}

