/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.transaction.spring;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.servicecomb.pack.omega.context.CallbackContext;
import org.apache.servicecomb.pack.omega.transaction.OmegaException;
import org.apache.servicecomb.pack.omega.transaction.spring.CallbackType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.ReflectionUtils;

public abstract class MethodCheckingCallback
implements ReflectionUtils.MethodCallback {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Object bean;
    private final CallbackContext callbackContext;
    private final CallbackType callbackType;

    public MethodCheckingCallback(Object bean, CallbackContext callbackContext, CallbackType callbackType) {
        this.bean = bean;
        this.callbackContext = callbackContext;
        this.callbackType = callbackType;
    }

    protected void loadMethodContext(Method method, String ... candidates) {
        for (String each : candidates) {
            try {
                Method signature = this.bean.getClass().getDeclaredMethod(each, method.getParameterTypes());
                String key = this.getTargetBean(this.bean).getClass().getDeclaredMethod(each, method.getParameterTypes()).toString();
                this.callbackContext.addCallbackContext(key, signature, this.bean);
                LOG.debug("Found callback method [{}] in {}", (Object)each, (Object)this.bean.getClass().getCanonicalName());
            }
            catch (Exception ex) {
                throw new OmegaException("No such " + (Object)((Object)this.callbackType) + " method [" + each + "] found in " + this.bean.getClass().getCanonicalName(), (Throwable)ex);
            }
        }
    }

    private Object getTargetBean(Object proxy) throws Exception {
        if (!AopUtils.isAopProxy((Object)proxy)) {
            return proxy;
        }
        if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
            return this.getJdkDynamicProxyTargetObject(proxy);
        }
        return this.getCglibProxyTargetObject(proxy);
    }

    private Object getCglibProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
        h.setAccessible(true);
        Object dynamicAdvisedInterceptor = h.get(proxy);
        Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object result = ((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
        return result;
    }

    private Object getJdkDynamicProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
        h.setAccessible(true);
        AopProxy aopProxy = (AopProxy)h.get(proxy);
        Field advised = aopProxy.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object result = ((AdvisedSupport)advised.get(aopProxy)).getTargetSource().getTarget();
        return result;
    }
}

