/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.pojo;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.core.CseContext;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.invocation.InvocationFactory;
import org.apache.servicecomb.core.provider.consumer.InvokerUtils;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfig;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfigUtils;
import org.apache.servicecomb.swagger.engine.SwaggerConsumer;
import org.apache.servicecomb.swagger.engine.SwaggerConsumerOperation;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.SwaggerInvocation;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionFactory;
import org.springframework.util.StringUtils;

public class Invoker
implements InvocationHandler {
    private String microserviceName;
    private String schemaId;
    private Class<?> consumerIntf;
    private SchemaMeta schemaMeta;
    private ReferenceConfig referenceConfig;
    private volatile SwaggerConsumer swaggerConsumer;

    public static <T> T createProxy(String microserviceName, String schemaId, Class<?> consumerIntf) {
        Invoker invoker = new Invoker(microserviceName, schemaId, consumerIntf);
        return (T)Proxy.newProxyInstance(consumerIntf.getClassLoader(), new Class[]{consumerIntf}, (InvocationHandler)invoker);
    }

    public Invoker(String microserviceName, String schemaId, Class<?> consumerIntf) {
        this.microserviceName = microserviceName;
        this.schemaId = schemaId;
        this.consumerIntf = consumerIntf;
    }

    protected void prepare() {
        this.referenceConfig = ReferenceConfigUtils.getForInvoke((String)this.microserviceName);
        MicroserviceMeta microserviceMeta = this.referenceConfig.getMicroserviceMeta();
        if (StringUtils.isEmpty((Object)this.schemaId)) {
            this.schemaMeta = microserviceMeta.findSchemaMeta(this.consumerIntf);
            if (this.schemaMeta == null) {
                this.schemaId = this.consumerIntf.getName();
                this.schemaMeta = microserviceMeta.ensureFindSchemaMeta(this.schemaId);
            }
        } else {
            this.schemaMeta = microserviceMeta.ensureFindSchemaMeta(this.schemaId);
        }
        this.swaggerConsumer = CseContext.getInstance().getSwaggerEnvironment().createConsumer(this.consumerIntf, this.schemaMeta.getSwaggerIntf());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.swaggerConsumer == null) {
            Invoker invoker = this;
            synchronized (invoker) {
                if (this.swaggerConsumer == null) {
                    this.prepare();
                }
            }
        }
        SwaggerConsumerOperation consumerOperation = this.swaggerConsumer.findOperation(method.getName());
        Invocation invocation = InvocationFactory.forConsumer((ReferenceConfig)this.referenceConfig, (SchemaMeta)this.schemaMeta, (String)consumerOperation.getSwaggerMethod().getName(), null);
        consumerOperation.getArgumentsMapper().toInvocation(args, (SwaggerInvocation)invocation);
        if (CompletableFuture.class.equals(method.getReturnType())) {
            return this.completableFutureInvoke(invocation, consumerOperation);
        }
        return this.syncInvoke(invocation, consumerOperation);
    }

    protected Object syncInvoke(Invocation invocation, SwaggerConsumerOperation consumerOperation) {
        Response response = InvokerUtils.innerSyncInvoke((Invocation)invocation);
        if (response.isSuccessed()) {
            return consumerOperation.getResponseMapper().mapResponse(response);
        }
        throw ExceptionFactory.convertConsumerException((Throwable)((Throwable)response.getResult()));
    }

    protected CompletableFuture<Object> completableFutureInvoke(Invocation invocation, SwaggerConsumerOperation consumerOperation) {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        InvokerUtils.reactiveInvoke((Invocation)invocation, response -> {
            if (response.isSuccessed()) {
                Object result = consumerOperation.getResponseMapper().mapResponse(response);
                future.complete(result);
                return;
            }
            future.completeExceptionally((Throwable)response.getResult());
        });
        return future;
    }
}

