/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.pojo;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.invocation.InvocationFactory;
import org.apache.servicecomb.core.provider.consumer.InvokerUtils;
import org.apache.servicecomb.core.provider.consumer.MicroserviceReferenceConfig;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfig;
import org.apache.servicecomb.provider.pojo.definition.PojoConsumerMeta;
import org.apache.servicecomb.provider.pojo.definition.PojoConsumerOperationMeta;
import org.apache.servicecomb.swagger.engine.SwaggerConsumer;
import org.apache.servicecomb.swagger.engine.SwaggerConsumerOperation;
import org.apache.servicecomb.swagger.generator.core.utils.MethodUtils;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.context.InvocationContext;
import org.apache.servicecomb.swagger.invocation.context.InvocationContextCompletableFuture;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionFactory;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Invoker
implements InvocationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Invoker.class);
    protected SCBEngine scbEngine;
    protected String appId;
    protected String microserviceName;
    protected String schemaId;
    protected Class<?> consumerIntf;
    protected PojoConsumerMeta consumerMeta;

    public static <T> T createProxy(String microserviceName, String schemaId, Class<?> consumerIntf) {
        Invoker invoker = new Invoker(microserviceName, schemaId, consumerIntf);
        return (T)Proxy.newProxyInstance(consumerIntf.getClassLoader(), new Class[]{consumerIntf}, (InvocationHandler)invoker);
    }

    public Invoker(String microserviceName, String schemaId, Class<?> consumerIntf) {
        this.microserviceName = microserviceName;
        this.schemaId = schemaId;
        this.consumerIntf = consumerIntf;
    }

    private void ensureStatusUp() {
        if (this.scbEngine == null) {
            if (SCBEngine.getInstance() == null) {
                String message = "The request is rejected. Cannot process the request due to SCBEngine not ready.";
                LOGGER.warn(message);
                throw new InvocationException((Response.StatusType)Response.Status.SERVICE_UNAVAILABLE, message);
            }
            this.scbEngine = SCBEngine.getInstance();
            this.appId = this.scbEngine.parseAppId(this.microserviceName);
        }
        this.scbEngine.ensureStatusUp();
    }

    private boolean isNeedRefresh() {
        return this.consumerMeta == null || this.consumerMeta.isExpired();
    }

    protected SchemaMeta findSchemaMeta(MicroserviceMeta microserviceMeta) {
        if (StringUtils.isNotEmpty((CharSequence)this.schemaId)) {
            return microserviceMeta.findSchemaMeta(this.schemaId);
        }
        SchemaMeta schemaMeta = microserviceMeta.findSchemaMeta(this.consumerIntf);
        if (schemaMeta != null) {
            return schemaMeta;
        }
        return microserviceMeta.findSchemaMeta(this.consumerIntf.getName());
    }

    private PojoConsumerMeta refreshMeta() {
        MicroserviceReferenceConfig microserviceReferenceConfig = this.scbEngine.createMicroserviceReferenceConfig(this.microserviceName);
        MicroserviceMeta microserviceMeta = microserviceReferenceConfig.getLatestMicroserviceMeta();
        SchemaMeta schemaMeta = this.findSchemaMeta(microserviceMeta);
        if (schemaMeta == null) {
            throw new IllegalStateException(String.format("Schema not exist, microserviceName=%s, schemaId=%s, consumer interface=%s; new producer not running or not deployed.", this.microserviceName, this.schemaId, this.consumerIntf.getName()));
        }
        SwaggerConsumer swaggerConsumer = this.scbEngine.getSwaggerEnvironment().createConsumer(this.consumerIntf, schemaMeta.getSwagger());
        return new PojoConsumerMeta(microserviceReferenceConfig, swaggerConsumer, schemaMeta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        PojoConsumerOperationMeta pojoConsumerOperationMeta;
        this.ensureStatusUp();
        if (this.isNeedRefresh()) {
            Invoker invoker = this;
            synchronized (invoker) {
                if (this.isNeedRefresh()) {
                    this.consumerMeta = this.refreshMeta();
                }
            }
        }
        if ((pojoConsumerOperationMeta = this.consumerMeta.findOperationMeta(MethodUtils.findSwaggerMethodName((Method)method))) == null) {
            throw new IllegalStateException(String.format("Consumer method %s:%s not exist in contract, microserviceName=%s, schemaId=%s; new producer not running or not deployed.", this.consumerIntf.getName(), method.getName(), this.microserviceName, this.schemaId));
        }
        SwaggerConsumerOperation consumerOperation = pojoConsumerOperationMeta.getSwaggerConsumerOperation();
        OperationMeta operationMeta = pojoConsumerOperationMeta.getOperationMeta();
        Invocation invocation = InvocationFactory.forConsumer((ReferenceConfig)this.findReferenceConfig(operationMeta), (OperationMeta)operationMeta, null);
        invocation.setResponsesMeta(pojoConsumerOperationMeta.getResponsesMeta());
        Map<String, Object> invocationArguments = this.toArguments(method, args);
        invocation.setInvocationArguments(invocationArguments);
        if (CompletableFuture.class.equals(method.getReturnType())) {
            return this.completableFutureInvoke(invocation, consumerOperation);
        }
        return this.syncInvoke(invocation, consumerOperation);
    }

    public Map<String, Object> toArguments(Method method, Object[] args) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        for (int i = 0; i < method.getParameterCount(); ++i) {
            arguments.put(method.getParameters()[i].getName(), args[i]);
        }
        return arguments;
    }

    protected ReferenceConfig findReferenceConfig(OperationMeta operationMeta) {
        return this.consumerMeta.getMicroserviceReferenceConfig().createReferenceConfig(operationMeta);
    }

    protected Object syncInvoke(Invocation invocation, SwaggerConsumerOperation consumerOperation) {
        Response response = InvokerUtils.innerSyncInvoke((Invocation)invocation);
        if (response.isSuccessed()) {
            return consumerOperation.getResponseMapper().mapResponse(response);
        }
        throw ExceptionFactory.convertConsumerException((Throwable)((Throwable)response.getResult()));
    }

    protected CompletableFuture<Object> completableFutureInvoke(Invocation invocation, SwaggerConsumerOperation consumerOperation) {
        InvocationContextCompletableFuture future = new InvocationContextCompletableFuture((InvocationContext)invocation);
        InvokerUtils.reactiveInvoke((Invocation)invocation, arg_0 -> Invoker.lambda$completableFutureInvoke$0(consumerOperation, (CompletableFuture)future, arg_0));
        return future;
    }

    private static /* synthetic */ void lambda$completableFutureInvoke$0(SwaggerConsumerOperation consumerOperation, CompletableFuture future, Response response) {
        if (response.isSuccessed()) {
            Object result = consumerOperation.getResponseMapper().mapResponse(response);
            future.complete(result);
            return;
        }
        future.completeExceptionally((Throwable)response.getResult());
    }
}

