/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.pojo;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.provider.consumer.InvokerUtils;
import org.apache.servicecomb.provider.pojo.DefaultMethodMeta;
import org.apache.servicecomb.provider.pojo.PojoConsumerMetaRefresher;
import org.apache.servicecomb.provider.pojo.PojoInvocationCreator;
import org.apache.servicecomb.provider.pojo.definition.PojoConsumerMeta;
import org.apache.servicecomb.provider.pojo.definition.PojoConsumerOperationMeta;
import org.apache.servicecomb.swagger.engine.SwaggerConsumerOperation;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.context.InvocationContext;
import org.apache.servicecomb.swagger.invocation.context.InvocationContextCompletableFuture;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionFactory;

public class Invoker
implements InvocationHandler {
    protected final PojoConsumerMetaRefresher metaRefresher;
    protected final PojoInvocationCreator invocationCreator;
    protected final DefaultMethodMeta defaultMethodMeta = new DefaultMethodMeta();

    public static <T> T createProxy(String microserviceName, String schemaId, Class<?> consumerIntf) {
        Invoker invoker = new Invoker(microserviceName, schemaId, consumerIntf);
        return (T)Proxy.newProxyInstance(consumerIntf.getClassLoader(), new Class[]{consumerIntf}, (InvocationHandler)invoker);
    }

    public Invoker(String microserviceName, String schemaId, Class<?> consumerIntf) {
        this.metaRefresher = this.createInvokerMeta(microserviceName, schemaId, consumerIntf);
        this.invocationCreator = this.createInvocationCreator();
    }

    protected PojoConsumerMetaRefresher createInvokerMeta(String microserviceName, String schemaId, Class<?> consumerIntf) {
        return new PojoConsumerMetaRefresher(microserviceName, schemaId, consumerIntf);
    }

    public PojoInvocationCreator createInvocationCreator() {
        return new PojoInvocationCreator();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.isDefault()) {
            return this.defaultMethodMeta.getOrCreateMethodHandle(proxy, method).invokeWithArguments(args);
        }
        PojoConsumerMeta pojoConsumerMeta = this.metaRefresher.getLatestMeta();
        PojoConsumerOperationMeta consumerOperationMeta = pojoConsumerMeta.ensureFindOperationMeta(method);
        Invocation invocation = this.invocationCreator.create(consumerOperationMeta, args);
        if (CompletableFuture.class.equals(method.getReturnType())) {
            return this.completableFutureInvoke(invocation, consumerOperationMeta.getSwaggerConsumerOperation());
        }
        return this.syncInvoke(invocation, consumerOperationMeta.getSwaggerConsumerOperation());
    }

    protected Object syncInvoke(Invocation invocation, SwaggerConsumerOperation consumerOperation) {
        Response response = InvokerUtils.innerSyncInvoke((Invocation)invocation);
        if (response.isSuccessed()) {
            return consumerOperation.getResponseMapper().mapResponse(response);
        }
        throw ExceptionFactory.convertConsumerException((Throwable)((Throwable)response.getResult()));
    }

    protected CompletableFuture<Object> completableFutureInvoke(Invocation invocation, SwaggerConsumerOperation consumerOperation) {
        InvocationContextCompletableFuture future = new InvocationContextCompletableFuture((InvocationContext)invocation);
        InvokerUtils.reactiveInvoke((Invocation)invocation, arg_0 -> Invoker.lambda$completableFutureInvoke$0(consumerOperation, (CompletableFuture)future, arg_0));
        return future;
    }

    private static /* synthetic */ void lambda$completableFutureInvoke$0(SwaggerConsumerOperation consumerOperation, CompletableFuture future, Response response) {
        if (response.isSuccessed()) {
            Object result = consumerOperation.getResponseMapper().mapResponse(response);
            future.complete(result);
            return;
        }
        future.completeExceptionally((Throwable)response.getResult());
    }
}

