/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.pojo;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.provider.pojo.DefaultMethodMeta;
import org.apache.servicecomb.provider.pojo.FilterInvocationCaller;
import org.apache.servicecomb.provider.pojo.HandlerInvocationCaller;
import org.apache.servicecomb.provider.pojo.InvocationCaller;
import org.apache.servicecomb.provider.pojo.PojoConsumerMetaRefresher;
import org.apache.servicecomb.provider.pojo.PojoInvocationCreator;

public class Invoker
implements InvocationHandler {
    protected final PojoConsumerMetaRefresher metaRefresher;
    protected final PojoInvocationCreator invocationCreator;
    protected final DefaultMethodMeta defaultMethodMeta = new DefaultMethodMeta();
    protected InvocationCaller invocationCaller;

    public static <T> T createProxy(String microserviceName, String schemaId, Class<?> consumerIntf) {
        Invoker invoker = new Invoker(microserviceName, schemaId, consumerIntf);
        return (T)Proxy.newProxyInstance(consumerIntf.getClassLoader(), new Class[]{consumerIntf}, (InvocationHandler)invoker);
    }

    public Invoker(String microserviceName, String schemaId, Class<?> consumerIntf) {
        this.metaRefresher = this.createInvokerMeta(microserviceName, schemaId, consumerIntf);
        this.invocationCreator = this.createInvocationCreator();
    }

    protected PojoConsumerMetaRefresher createInvokerMeta(String microserviceName, String schemaId, Class<?> consumerIntf) {
        return new PojoConsumerMetaRefresher(microserviceName, schemaId, consumerIntf);
    }

    public PojoInvocationCreator createInvocationCreator() {
        return new PojoInvocationCreator();
    }

    protected InvocationCaller createInvocationCaller() {
        if (SCBEngine.getInstance().isFilterChainEnabled()) {
            return new FilterInvocationCaller();
        }
        return new HandlerInvocationCaller();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.isDefault()) {
            return this.defaultMethodMeta.getOrCreateMethodHandle(proxy, method).invokeWithArguments(args);
        }
        this.prepareInvocationCaller();
        return this.invocationCaller.call(method, this.metaRefresher, this.invocationCreator, args);
    }

    protected void prepareInvocationCaller() {
        if (this.invocationCaller != null) {
            return;
        }
        this.invocationCaller = this.createInvocationCaller();
    }
}

