/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.pojo;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.core.provider.producer.AbstractProducerProvider;
import org.apache.servicecomb.core.provider.producer.ProducerMeta;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.provider.pojo.InstanceFactory;
import org.apache.servicecomb.provider.pojo.instance.PojoInstanceFactory;
import org.apache.servicecomb.provider.pojo.instance.SpringInstanceFactory;
import org.apache.servicecomb.provider.pojo.schema.PojoProducerMeta;
import org.apache.servicecomb.provider.pojo.schema.PojoProducers;

public class PojoProducerProvider
extends AbstractProducerProvider {
    private Map<String, InstanceFactory> instanceFactoryMgr = new HashMap<String, InstanceFactory>();

    private void registerInstanceFactory(InstanceFactory instanceFactory) {
        this.instanceFactoryMgr.put(instanceFactory.getImplName(), instanceFactory);
    }

    public PojoProducerProvider() {
        this.registerInstanceFactory(new PojoInstanceFactory());
        this.registerInstanceFactory(new SpringInstanceFactory());
    }

    public List<ProducerMeta> init() {
        if (BeanUtils.getContext() == null) {
            return Collections.emptyList();
        }
        PojoProducers pojoProducers = (PojoProducers)BeanUtils.getContext().getBean(PojoProducers.class);
        for (ProducerMeta producerMeta : pojoProducers.getProducerMetas()) {
            PojoProducerMeta pojoProducerMeta = (PojoProducerMeta)producerMeta;
            this.initPojoProducerMeta(pojoProducerMeta);
        }
        return pojoProducers.getProducerMetas();
    }

    public String getName() {
        return "pojo";
    }

    private void initPojoProducerMeta(PojoProducerMeta pojoProducerMeta) {
        this.parseSchemaInterface(pojoProducerMeta);
        this.parseImplementation(pojoProducerMeta);
    }

    private void parseImplementation(PojoProducerMeta pojoProducerMeta) {
        InstanceFactory factory;
        if (pojoProducerMeta.getInstance() != null) {
            return;
        }
        String implementation = pojoProducerMeta.getImplementation();
        String implName = "pojo";
        String implValue = pojoProducerMeta.getImplementation();
        int idx = implementation.indexOf(58);
        if (idx != -1) {
            implName = implementation.substring(0, idx);
            implValue = implementation.substring(idx + 1);
        }
        if ((factory = this.instanceFactoryMgr.get(implName)) == null) {
            throw new IllegalStateException("failed to find instance factory, name=" + implName);
        }
        Object instance = factory.create(implValue);
        pojoProducerMeta.setInstance(instance);
    }

    private void parseSchemaInterface(PojoProducerMeta pojoProducerMeta) {
        if (pojoProducerMeta.getSchemaInterface() != null || StringUtils.isEmpty((CharSequence)pojoProducerMeta.getSchemaInterfaceName())) {
            return;
        }
        try {
            Class<?> si = Class.forName(pojoProducerMeta.getSchemaInterfaceName());
            pojoProducerMeta.setSchemaInterface(si);
        }
        catch (Exception e) {
            throw new Error("can not find schema interface " + pojoProducerMeta.getSchemaInterfaceName(), e);
        }
    }
}

