/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.service.center.client;

import java.util.ArrayList;
import java.util.List;
import org.apache.servicecomb.http.client.common.HttpUtils;

public class AddressManager {
    private final String projectName;
    private final List<String> addresses;
    private int index = 0;

    public AddressManager(String projectName, List<String> addresses) {
        this.projectName = projectName;
        this.addresses = new ArrayList<String>(addresses.size());
        this.addresses.addAll(addresses);
    }

    private String formatAddress(String address) {
        try {
            return address + "/v4/" + HttpUtils.encodeURLParam((String)this.projectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("not possible");
        }
    }

    public boolean sslEnabled() {
        return this.address().startsWith("https://");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String address() {
        AddressManager addressManager = this;
        synchronized (addressManager) {
            ++this.index;
            if (this.index >= this.addresses.size()) {
                this.index = 0;
            }
            return this.addresses.get(this.index);
        }
    }

    public String formatUrl(String url, boolean absoluteUrl) {
        return absoluteUrl ? this.address() + url : this.formatAddress(this.address()) + url;
    }
}

