/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.consumer;

import com.google.common.eventbus.Subscribe;
import java.util.Map;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.serviceregistry.consumer.AppManager;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersionRule;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersions;
import org.apache.servicecomb.serviceregistry.task.event.PeriodicPullEvent;
import org.apache.servicecomb.serviceregistry.task.event.RecoveryEvent;

public class MicroserviceManager {
    private AppManager appManager;
    private String appId;
    private Map<String, MicroserviceVersions> versionsByName = new ConcurrentHashMapEx();

    public MicroserviceManager(AppManager appManager, String appId) {
        this.appManager = appManager;
        this.appId = appId;
        appManager.getEventBus().register((Object)this);
    }

    public MicroserviceVersions getOrCreateMicroserviceVersions(String microserviceName) {
        MicroserviceVersions microserviceVersions = this.versionsByName.computeIfAbsent(microserviceName, name -> {
            MicroserviceVersions instance = new MicroserviceVersions(this.appManager, this.appId, microserviceName);
            instance.submitPull();
            return instance;
        });
        if (!microserviceVersions.isValidated()) {
            this.versionsByName.remove(microserviceName);
        }
        return microserviceVersions;
    }

    public MicroserviceVersionRule getOrCreateMicroserviceVersionRule(String microserviceName, String versionRule) {
        MicroserviceVersions microserviceVersions = this.getOrCreateMicroserviceVersions(microserviceName);
        return microserviceVersions.getOrCreateMicroserviceVersionRule(versionRule);
    }

    @Subscribe
    public void periodicPull(PeriodicPullEvent event) {
        this.refreshInstances();
    }

    @Subscribe
    public void serviceRegistryRecovery(RecoveryEvent event) {
        this.refreshInstances();
    }

    protected void refreshInstances() {
        for (MicroserviceVersions versions : this.versionsByName.values()) {
            versions.submitPull();
        }
    }
}

