/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.task;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import org.apache.servicecomb.foundation.vertx.AsyncResultCallback;
import org.apache.servicecomb.serviceregistry.api.registry.Microservice;
import org.apache.servicecomb.serviceregistry.api.response.MicroserviceInstanceChangedEvent;
import org.apache.servicecomb.serviceregistry.client.ServiceRegistryClient;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.apache.servicecomb.serviceregistry.task.AbstractTask;
import org.apache.servicecomb.serviceregistry.task.MicroserviceInstanceRegisterTask;
import org.apache.servicecomb.serviceregistry.task.TaskStatus;
import org.apache.servicecomb.serviceregistry.task.event.ExceptionEvent;
import org.apache.servicecomb.serviceregistry.task.event.RecoveryEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroserviceWatchTask
extends AbstractTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroserviceWatchTask.class);
    private ServiceRegistryConfig serviceRegistryConfig;

    public MicroserviceWatchTask(EventBus eventBus, ServiceRegistryConfig serviceRegistryConfig, ServiceRegistryClient srClient, Microservice microservice) {
        super(eventBus, srClient, microservice);
        this.serviceRegistryConfig = serviceRegistryConfig;
    }

    @Subscribe
    public void onMicroserviceInstanceRegisterTask(MicroserviceInstanceRegisterTask task) {
        if (task.taskStatus == TaskStatus.FINISHED && this.isSameMicroservice(task.getMicroservice())) {
            this.taskStatus = TaskStatus.READY;
        }
    }

    @Override
    public void doRun() {
        if (!this.needToWatch()) {
            return;
        }
        this.srClient.watch(this.microservice.getServiceId(), (AsyncResultCallback<MicroserviceInstanceChangedEvent>)((AsyncResultCallback)event -> {
            if (event.failed()) {
                this.eventBus.post((Object)new ExceptionEvent(event.cause()));
                return;
            }
            MicroserviceInstanceChangedEvent changedEvent = (MicroserviceInstanceChangedEvent)event.result();
            if (this.isProviderInstancesChanged(changedEvent) && !this.serviceRegistryConfig.isWatch()) {
                return;
            }
            if (!this.isProviderInstancesChanged(changedEvent) && !this.serviceRegistryConfig.isRegistryAutoDiscovery()) {
                return;
            }
            this.onMicroserviceInstanceChanged(changedEvent);
        }), (AsyncResultCallback<Void>)((AsyncResultCallback)open -> this.eventBus.post((Object)new RecoveryEvent())), (AsyncResultCallback<Void>)((AsyncResultCallback)close -> {}));
    }

    private void onMicroserviceInstanceChanged(MicroserviceInstanceChangedEvent changedEvent) {
        switch (changedEvent.getAction()) {
            case CREATE: {
                LOGGER.info("microservice {}/{}/{} REGISTERED an instance {}, {}.", new Object[]{changedEvent.getKey().getAppId(), changedEvent.getKey().getServiceName(), changedEvent.getKey().getVersion(), changedEvent.getInstance().getInstanceId(), changedEvent.getInstance().getEndpoints()});
                break;
            }
            case DELETE: {
                LOGGER.info("microservice {}/{}/{} UNREGISTERED an instance {}, {}.", new Object[]{changedEvent.getKey().getAppId(), changedEvent.getKey().getServiceName(), changedEvent.getKey().getVersion(), changedEvent.getInstance().getInstanceId(), changedEvent.getInstance().getEndpoints()});
                break;
            }
            case EXPIRE: {
                LOGGER.info("microservice {}/{} EXPIRE all instance.", (Object)changedEvent.getKey().getAppId(), (Object)changedEvent.getKey().getServiceName());
                break;
            }
            case UPDATE: {
                LOGGER.info("microservice {}/{}/{} UPDATE an instance {} status or metadata, {}.", new Object[]{changedEvent.getKey().getAppId(), changedEvent.getKey().getServiceName(), changedEvent.getKey().getVersion(), changedEvent.getInstance().getInstanceId(), changedEvent.getInstance().getEndpoints()});
                break;
            }
        }
        this.eventBus.post((Object)changedEvent);
    }

    private boolean needToWatch() {
        return this.serviceRegistryConfig.isWatch();
    }

    private boolean isProviderInstancesChanged(MicroserviceInstanceChangedEvent changedEvent) {
        return !"default".equals(changedEvent.getKey().getAppId()) && !"SERVICECENTER".equals(changedEvent.getKey().getServiceName());
    }
}

