/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.task;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCenterTaskMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCenterTaskMonitor.class);
    private static final long MAX_TIME_TAKEN = 1000L;
    private long beginTime = 0L;
    private long lastEndTime = 0L;
    private int interval = -1;

    public void beginCycle(int interval) {
        this.beginTime = System.currentTimeMillis();
        if (this.interval != interval) {
            LOGGER.warn("sc task interval changed from {} to {}", (Object)this.interval, (Object)interval);
            this.interval = interval;
        } else if (this.beginTime - this.lastEndTime > (long)(interval * 1000) + 1000L) {
            LOGGER.warn("sc task postponed for {}ms for some reason.", (Object)(this.beginTime - this.lastEndTime));
        }
    }

    public void endCycle() {
        this.lastEndTime = System.currentTimeMillis();
        if (this.lastEndTime - this.beginTime > 1000L) {
            LOGGER.warn("sc task taken more than {}ms to execute", (Object)(this.lastEndTime - this.beginTime));
        }
    }
}

