/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.api.registry;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.netflix.config.DynamicPropertyFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.servicecomb.serviceregistry.api.registry.DataCenterInfo;
import org.apache.servicecomb.serviceregistry.api.registry.HealthCheck;
import org.apache.servicecomb.serviceregistry.api.registry.HealthCheckMode;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstanceStatus;
import org.apache.servicecomb.serviceregistry.config.InstancePropertiesLoader;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MicroserviceInstance {
    private String instanceId;
    private String serviceId;
    private List<String> endpoints = new ArrayList<String>();
    private String hostName;
    private MicroserviceInstanceStatus status = MicroserviceInstanceStatus.UP;
    private Map<String, String> properties = new HashMap<String, String>();
    private HealthCheck healthCheck;
    @Deprecated
    private String environment;
    private String stage;
    private DataCenterInfo dataCenterInfo;

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public List<String> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<String> endpoints) {
        this.endpoints = endpoints;
    }

    public MicroserviceInstanceStatus getStatus() {
        return this.status;
    }

    public void setStatus(MicroserviceInstanceStatus status) {
        this.status = status;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    public void setHealthCheck(HealthCheck healthCheck) {
        this.healthCheck = healthCheck;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    @Deprecated
    public String getStage() {
        return this.stage;
    }

    @Deprecated
    public void setStage(String stage) {
        this.stage = stage;
    }

    public DataCenterInfo getDataCenterInfo() {
        return this.dataCenterInfo;
    }

    public int hashCode() {
        return this.instanceId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MicroserviceInstance) {
            return this.instanceId.equals(((MicroserviceInstance)obj).instanceId);
        }
        return false;
    }

    public void setDataCenterInfo(DataCenterInfo dataCenterInfo) {
        this.dataCenterInfo = dataCenterInfo;
    }

    public static MicroserviceInstance createFromDefinition(Configuration configuration) {
        MicroserviceInstance microserviceInstance = new MicroserviceInstance();
        microserviceInstance.setStage("prod");
        microserviceInstance.setEnvironment(configuration.getString("instance_description.environment", "production"));
        HealthCheck healthCheck = new HealthCheck();
        healthCheck.setMode(HealthCheckMode.HEARTBEAT);
        microserviceInstance.setHealthCheck(healthCheck);
        Map<String, String> propertiesMap = InstancePropertiesLoader.INSTANCE.loadProperties(configuration);
        microserviceInstance.setProperties(propertiesMap);
        MicroserviceInstance.loadDataCenterInfo(microserviceInstance);
        return microserviceInstance;
    }

    private static void loadDataCenterInfo(MicroserviceInstance microserviceInstance) {
        String dataCenterName = DynamicPropertyFactory.getInstance().getStringProperty("cse.datacenter.name", null).get();
        if (StringUtils.isNotEmpty((String)dataCenterName)) {
            DataCenterInfo dataCenterInfo = new DataCenterInfo();
            dataCenterInfo.setName(dataCenterName);
            dataCenterInfo.setRegion(DynamicPropertyFactory.getInstance().getStringProperty("cse.datacenter.region", null).get());
            dataCenterInfo.setAvailableZone(DynamicPropertyFactory.getInstance().getStringProperty("cse.datacenter.availableZone", null).get());
            microserviceInstance.setDataCenterInfo(dataCenterInfo);
        }
    }
}

