/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.consumer;

import com.google.common.eventbus.EventBus;
import java.util.Map;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.serviceregistry.consumer.DefaultMicroserviceVersionFactory;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceManager;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersionFactory;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersionRule;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersions;

public class AppManager {
    private EventBus eventBus;
    private MicroserviceVersionFactory microserviceVersionFactory = new DefaultMicroserviceVersionFactory();
    private Map<String, MicroserviceManager> apps = new ConcurrentHashMapEx();

    public AppManager(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public MicroserviceVersionFactory getMicroserviceVersionFactory() {
        return this.microserviceVersionFactory;
    }

    public Map<String, MicroserviceManager> getApps() {
        return this.apps;
    }

    public void setMicroserviceVersionFactory(MicroserviceVersionFactory microserviceVersionFactory) {
        this.microserviceVersionFactory = microserviceVersionFactory;
    }

    public MicroserviceVersionRule getOrCreateMicroserviceVersionRule(String appId, String microserviceName, String versionRule) {
        MicroserviceManager microserviceManager = this.getOrCreateMicroserviceManager(appId);
        return microserviceManager.getOrCreateMicroserviceVersionRule(microserviceName, versionRule);
    }

    public MicroserviceManager getOrCreateMicroserviceManager(String appId) {
        return this.apps.computeIfAbsent(appId, id -> new MicroserviceManager(this, appId));
    }

    public MicroserviceVersions getOrCreateMicroserviceVersions(String appId, String microserviceName) {
        MicroserviceManager microserviceManager = this.getOrCreateMicroserviceManager(appId);
        return microserviceManager.getOrCreateMicroserviceVersions(microserviceName);
    }
}

